/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import com.google.gwt.i18n.server.GwtLocaleImpl;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.i18n.shared.GwtLocaleFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class GwtLocaleFactoryImpl
implements GwtLocaleFactory {
    private Map<GwtLocaleImpl, GwtLocaleImpl> instanceCache = new HashMap<GwtLocaleImpl, GwtLocaleImpl>();

    private static boolean isAlpha(String str, int min, int max) {
        int len = str.length();
        if (len < min || len > max) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isLetter(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isDigit(String str, int min, int max) {
        int len = str.length();
        if (len < min || len > max) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String titleCase(String str) {
        if (str.length() < 2) {
            return str.toUpperCase(Locale.ENGLISH);
        }
        return String.valueOf(Character.toTitleCase(str.charAt(0))) + str.substring(1).toLowerCase(Locale.ENGLISH);
    }

    public void clear() {
        this.instanceCache.clear();
    }

    public GwtLocale fromComponents(String language, String script, String region, String variant) {
        GwtLocaleImpl locale;
        if (language != null && language.length() == 0) {
            language = null;
        }
        if (language != null) {
            language = language.toLowerCase(Locale.ENGLISH);
        }
        if (script != null && script.length() == 0) {
            script = null;
        }
        if (script != null) {
            script = GwtLocaleFactoryImpl.titleCase(script);
        }
        if (region != null && region.length() == 0) {
            region = null;
        }
        if (region != null) {
            region = region.toUpperCase(Locale.ENGLISH);
        }
        if (variant != null && variant.length() == 0) {
            variant = null;
        }
        if (variant != null) {
            variant = variant.toUpperCase(Locale.ENGLISH);
        }
        if (this.instanceCache.containsKey(locale = new GwtLocaleImpl(this, language, region, script, variant))) {
            return this.instanceCache.get(locale);
        }
        this.instanceCache.put(locale, locale);
        return locale;
    }

    public GwtLocale fromString(String localeName) {
        String language = null;
        String script = null;
        String region = null;
        String variant = null;
        if (localeName != null && !"default".equals(localeName)) {
            int len;
            String part;
            int len2;
            ArrayList<String> localeParts = new ArrayList<String>();
            String[] parts = localeName.split("[-_]");
            for (int i = 0; i < parts.length; ++i) {
                if (parts[i].length() == 1 && i + 1 < parts.length) {
                    localeParts.add(parts[i] + '-' + parts[++i]);
                    continue;
                }
                localeParts.add(parts[i]);
            }
            int partIdx = 1;
            int numParts = localeParts.size();
            if (numParts > 0 && ((len2 = (language = (String)localeParts.get(0)).length()) == 2 || len2 == 3) && partIdx < numParts) {
                String part2 = (String)localeParts.get(partIdx);
                while (partIdx < numParts && partIdx < 4 && GwtLocaleFactoryImpl.isAlpha(part2, 3, 3)) {
                    language = language + '-' + part2;
                    if (++partIdx >= numParts) break;
                    part2 = (String)localeParts.get(partIdx);
                }
            }
            if (numParts > partIdx && GwtLocaleFactoryImpl.isAlpha((String)localeParts.get(partIdx), 4, 4)) {
                script = (String)localeParts.get(partIdx++);
            }
            if (partIdx < numParts && (GwtLocaleFactoryImpl.isAlpha(part = (String)localeParts.get(partIdx), 2, 2) || GwtLocaleFactoryImpl.isDigit(part, 3, 3))) {
                region = part;
                ++partIdx;
            }
            if (partIdx < numParts && ((len = (part = (String)localeParts.get(partIdx)).length()) >= 5 && len <= 8 || len == 4 && Character.isDigit(part.charAt(0)))) {
                variant = part;
                ++partIdx;
            }
            if (partIdx < numParts) {
                throw new IllegalArgumentException("Unrecognized locale format: " + localeName);
            }
        }
        return this.fromComponents(language, script, region, variant);
    }

    public GwtLocale getDefault() {
        return this.fromComponents(null, null, null, null);
    }
}

