/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.util.DefaultTextOutput;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dom.client.Element;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.css.CssGenerationVisitor;
import com.google.gwt.resources.css.GenerateCssAst;
import com.google.gwt.resources.css.ast.CollapsedNode;
import com.google.gwt.resources.css.ast.Context;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssEval;
import com.google.gwt.resources.css.ast.CssExternalSelectors;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssMediaRule;
import com.google.gwt.resources.css.ast.CssModVisitor;
import com.google.gwt.resources.css.ast.CssNoFlip;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssNodeCloner;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssSelector;
import com.google.gwt.resources.css.ast.CssSprite;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.resources.css.ast.CssUrl;
import com.google.gwt.resources.css.ast.CssVisitor;
import com.google.gwt.resources.ext.AbstractResourceGenerator;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.rg.Counter;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.zip.Adler32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssResourceGenerator
extends AbstractResourceGenerator {
    private static final char[] BASE32_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '-', '0', '1', '2', '3', '4'};
    private static final int CONCAT_EXPRESSION_LIMIT = 20;
    private static final String KEY_BY_CLASS_AND_METHOD = "classAndMethod";
    private static final String KEY_HAS_CACHED_DATA = "hasCachedData";
    private static final String KEY_SHARED_METHODS = "sharedMethods";
    private static final String KEY_CLASS_PREFIX = "prefix";
    private static final String KEY_CLASS_COUNTER = "counter";
    private Counter classCounter;
    private JClassType cssResourceType;
    private JClassType elementType;
    private boolean enableMerge;
    private boolean prettyOutput;
    private Map<JClassType, Map<JMethod, String>> replacementsByClassAndMethod;
    private Map<JMethod, String> replacementsForSharedMethods;
    private JClassType stringType;
    private Map<JMethod, CssStylesheet> stylesheetMap;

    public static void main(String[] args) {
        for (int i = 0; i < 1000; ++i) {
            System.out.println(CssResourceGenerator.makeIdent(i));
        }
    }

    static boolean haveCommonProperties(CssRule a, CssRule b) {
        if (a.getProperties().size() == 0 || b.getProperties().size() == 0) {
            return false;
        }
        TreeSet<String> aProperties = new TreeSet<String>();
        TreeSet<String> bProperties = new TreeSet<String>();
        for (CssProperty p : a.getProperties()) {
            aProperties.add(p.getName());
        }
        for (CssProperty p : b.getProperties()) {
            bProperties.add(p.getName());
        }
        Iterator ai = aProperties.iterator();
        Iterator bi = bProperties.iterator();
        String aName = (String)ai.next();
        String bName = (String)bi.next();
        while (true) {
            int comp;
            if ((comp = aName.compareToIgnoreCase(bName)) == 0) {
                return true;
            }
            if (comp > 0) {
                if (aName.startsWith(bName + "-")) {
                    return true;
                }
                if (!bi.hasNext()) break;
                bName = (String)bi.next();
                continue;
            }
            if (bName.startsWith(aName + "-")) {
                return true;
            }
            if (!ai.hasNext()) break;
            aName = (String)ai.next();
        }
        return false;
    }

    static <T extends CssNode> String makeExpression(TreeLogger logger, ResourceContext context, JClassType cssResourceType, T node, boolean prettyOutput) throws UnableToCompleteException {
        DefaultTextOutput out = new DefaultTextOutput(!prettyOutput);
        CssGenerationVisitor v = new CssGenerationVisitor((TextOutput)out);
        v.accept(node);
        String template = out.toString();
        StringBuilder b = new StringBuilder();
        int start = 0;
        int numExpressions = 0;
        b.append('(');
        for (Map.Entry<Integer, List<CssNode>> entry : v.getSubstitutionPositions().entrySet()) {
            b.append('\"');
            b.append(Generator.escape((String)template.substring(start, entry.getKey())));
            b.append('\"');
            numExpressions = CssResourceGenerator.concatOp(numExpressions, b);
            for (CssNode x : entry.getValue()) {
                TreeLogger loopLogger = logger.branch(TreeLogger.DEBUG, "Performing substitution in node " + x.toString());
                if (x instanceof CssIf) {
                    CssIf asIf = (CssIf)x;
                    String expression = CssResourceGenerator.makeExpression(loopLogger, context, cssResourceType, new CollapsedNode(asIf), prettyOutput);
                    String elseExpression = asIf.getElseNodes().isEmpty() ? "\"\"" : CssResourceGenerator.makeExpression(loopLogger, context, cssResourceType, new CollapsedNode(asIf.getElseNodes()), prettyOutput);
                    b.append("((" + asIf.getExpression() + ") ? " + expression + " : " + elseExpression + ") ");
                    numExpressions = CssResourceGenerator.concatOp(numExpressions, b);
                    continue;
                }
                if (x instanceof CssProperty) {
                    CssProperty property = (CssProperty)x;
                    CssResourceGenerator.validateValue(loopLogger, context.getClientBundleType(), property.getValues());
                    b.append("(" + property.getValues().getExpression() + ") ");
                    numExpressions = CssResourceGenerator.concatOp(numExpressions, b);
                    continue;
                }
                loopLogger.log(TreeLogger.ERROR, "Unhandled substitution " + x.getClass());
                throw new UnableToCompleteException();
            }
            start = entry.getKey();
        }
        b.append('\"');
        b.append(Generator.escape((String)template.substring(start)));
        b.append('\"');
        b.append(')');
        return b.toString();
    }

    private static int concatOp(int numExpressions, StringBuilder b) {
        if (numExpressions >= 20) {
            b.append(") + (");
            return 0;
        }
        b.append(" + ");
        return numExpressions + 1;
    }

    private static String makeIdent(long id) {
        assert (id >= 0L);
        StringBuilder b = new StringBuilder();
        b.append(BASE32_CHARS[(int)(id & 0xFL)]);
        id >>= 4;
        while (id != 0L) {
            b.append(BASE32_CHARS[(int)(id & 0x1FL)]);
            id >>= 5;
        }
        return b.toString();
    }

    private static void validateValue(TreeLogger logger, JClassType resourceBundleType, CssProperty.Value value) throws UnableToCompleteException {
        CssProperty.ListValue list = value.isListValue();
        if (list != null) {
            for (CssProperty.Value v : list.getValues()) {
                CssResourceGenerator.validateValue(logger, resourceBundleType, v);
            }
            return;
        }
        CssProperty.DotPathValue dot = value.isDotPathValue();
        if (dot != null) {
            String[] elements = dot.getPath().split("\\.");
            if (elements.length == 0) {
                logger.log(TreeLogger.ERROR, "value() functions must specify a path");
                throw new UnableToCompleteException();
            }
            JClassType currentType = resourceBundleType;
            for (String pathElement : Arrays.asList(elements)) {
                JClassType referenceType = currentType.isClassOrInterface();
                if (referenceType == null) {
                    logger.log(TreeLogger.ERROR, "Cannot resolve member " + pathElement + " on non-reference type " + currentType.getQualifiedSourceName());
                    throw new UnableToCompleteException();
                }
                try {
                    JMethod m = referenceType.getMethod(pathElement, new JType[0]);
                    currentType = m.getReturnType();
                }
                catch (NotFoundException e) {
                    logger.log(TreeLogger.ERROR, "Could not find no-arg method named " + pathElement + " in type " + currentType.getQualifiedSourceName());
                    throw new UnableToCompleteException();
                }
            }
            return;
        }
    }

    @Override
    public String createAssignment(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        StringSourceWriter sw = new StringSourceWriter();
        sw.println("new " + method.getReturnType().getQualifiedSourceName() + "() {");
        sw.indent();
        JClassType cssResourceSubtype = method.getReturnType().isInterface();
        assert (cssResourceSubtype != null);
        HashMap<String, Map<JMethod, String>> replacementsWithPrefix = new HashMap<String, Map<JMethod, String>>();
        replacementsWithPrefix.put("", this.computeReplacementsForType(cssResourceSubtype));
        CssResource.Import imp = (CssResource.Import)method.getAnnotation(CssResource.Import.class);
        if (imp != null) {
            boolean fail = false;
            for (Class<? extends CssResource> clazz : imp.value()) {
                JClassType importType = context.getGeneratorContext().getTypeOracle().findType(clazz.getName().replace('$', '.'));
                assert (importType != null);
                String prefix = importType.getSimpleSourceName();
                CssResource.ImportedWithPrefix exp = (CssResource.ImportedWithPrefix)importType.getAnnotation(CssResource.ImportedWithPrefix.class);
                if (exp != null) {
                    prefix = exp.value();
                }
                if (replacementsWithPrefix.put(prefix + "-", this.computeReplacementsForType(importType)) == null) continue;
                logger.log(TreeLogger.ERROR, "Multiple imports that would use the prefix " + prefix);
                fail = true;
            }
            if (fail) {
                throw new UnableToCompleteException();
            }
        }
        sw.println("public String getText() {");
        sw.indent();
        boolean strict = this.isStrict(logger, context, method);
        IdentityHashMap<JMethod, String> actualReplacements = new IdentityHashMap<JMethod, String>();
        String cssExpression = this.makeExpression(logger, context, cssResourceSubtype, this.stylesheetMap.get(method), replacementsWithPrefix, strict, actualReplacements);
        sw.println("return " + cssExpression + ";");
        sw.outdent();
        sw.println("}");
        sw.println("public String getName() {");
        sw.indent();
        sw.println("return \"" + method.getName() + "\";");
        sw.outdent();
        sw.println("}");
        this.writeUserMethods(logger, (SourceWriter)sw, this.stylesheetMap.get(method), cssResourceSubtype.getOverridableMethods(), actualReplacements);
        sw.outdent();
        sw.println("}");
        return sw.toString();
    }

    @Override
    public void init(TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        String classPrefix;
        try {
            PropertyOracle propertyOracle = context.getGeneratorContext().getPropertyOracle();
            ConfigurationProperty styleProp = propertyOracle.getConfigurationProperty("CssResource.style");
            String style = (String)styleProp.getValues().get(0);
            this.prettyOutput = style.equals("pretty");
            ConfigurationProperty mergeProp = propertyOracle.getConfigurationProperty("CssResource.mergeEnabled");
            String merge = (String)mergeProp.getValues().get(0);
            this.enableMerge = merge.equals("true");
            ConfigurationProperty classPrefixProp = propertyOracle.getConfigurationProperty("CssResource.obfuscationPrefix");
            classPrefix = (String)classPrefixProp.getValues().get(0);
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "Unable to query module property", (Throwable)e);
            throw new UnableToCompleteException();
        }
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        this.cssResourceType = typeOracle.findType(CssResource.class.getName());
        assert (this.cssResourceType != null);
        this.elementType = typeOracle.findType(Element.class.getName());
        assert (this.elementType != null);
        this.stringType = typeOracle.findType(String.class.getName());
        assert (this.stringType != null);
        this.stylesheetMap = new IdentityHashMap<JMethod, CssStylesheet>();
        this.initReplacements(logger, context, classPrefix);
    }

    @Override
    public void prepare(TreeLogger logger, ResourceContext context, ClientBundleRequirements requirements, JMethod method) throws UnableToCompleteException {
        if (method.getReturnType().isInterface() == null) {
            logger.log(TreeLogger.ERROR, "Return type must be an interface");
            throw new UnableToCompleteException();
        }
        URL[] resources = ResourceGeneratorUtil.findResources(logger, context, method);
        if (resources.length == 0) {
            logger.log(TreeLogger.ERROR, "At least one source must be specified");
            throw new UnableToCompleteException();
        }
        CssStylesheet sheet = GenerateCssAst.exec(logger, resources);
        this.stylesheetMap.put(method, sheet);
        new RequirementsCollector(logger, requirements).accept(sheet);
    }

    private String computeClassPrefix(String classPrefix, SortedSet<JClassType> cssResourceSubtypes) {
        if ("default".equals(classPrefix)) {
            classPrefix = null;
        } else if ("empty".equals(classPrefix)) {
            classPrefix = "";
        }
        if (classPrefix == null) {
            Adler32 checksum = new Adler32();
            for (JClassType type : cssResourceSubtypes) {
                checksum.update(Util.getBytes((String)type.getQualifiedSourceName()));
            }
            classPrefix = "G" + Long.toString(checksum.getValue(), 36);
        }
        return classPrefix;
    }

    private void computeObfuscatedNames(TreeLogger logger, String classPrefix, Set<JClassType> cssResourceSubtypes) {
        logger = logger.branch(TreeLogger.DEBUG, "Computing CSS class replacements");
        for (JClassType type : cssResourceSubtypes) {
            if (this.replacementsByClassAndMethod.containsKey(type)) continue;
            IdentityHashMap<JMethod, String> replacements = new IdentityHashMap<JMethod, String>();
            this.replacementsByClassAndMethod.put(type, replacements);
            for (JMethod method : type.getOverridableMethods()) {
                CssResource.Shared shared;
                String name = method.getName();
                if ("getName".equals(name) || "getText".equals(name) || !this.stringType.equals((Object)method.getReturnType())) continue;
                CssResource.ClassName classNameOverride = (CssResource.ClassName)method.getAnnotation(CssResource.ClassName.class);
                if (classNameOverride != null) {
                    name = classNameOverride.value();
                }
                String obfuscatedClassName = classPrefix + CssResourceGenerator.makeIdent(this.classCounter.next());
                if (this.prettyOutput) {
                    obfuscatedClassName = obfuscatedClassName + "-" + type.getQualifiedSourceName().replaceAll("[.$]", "-") + "-" + name;
                }
                replacements.put(method, obfuscatedClassName);
                if (method.getEnclosingType() == type && (shared = (CssResource.Shared)type.getAnnotation(CssResource.Shared.class)) != null) {
                    this.replacementsForSharedMethods.put(method, obfuscatedClassName);
                }
                logger.log(TreeLogger.SPAM, "Mapped " + type.getQualifiedSourceName() + "." + name + " to " + obfuscatedClassName);
            }
        }
    }

    private SortedSet<JClassType> computeOperableTypes(TreeLogger logger) {
        JClassType[] cssResourceSubtypes;
        logger = logger.branch(TreeLogger.DEBUG, "Finding operable CssResource subtypes");
        TreeSet<JClassType> toReturn = new TreeSet<JClassType>(new JClassOrderComparator());
        for (JClassType type : cssResourceSubtypes = this.cssResourceType.getSubtypes()) {
            if (type.isInterface() != null) {
                logger.log(TreeLogger.SPAM, "Added " + type.getQualifiedSourceName());
                toReturn.add(type);
                continue;
            }
            logger.log(TreeLogger.SPAM, "Ignored " + type.getQualifiedSourceName());
        }
        return toReturn;
    }

    private Map<JMethod, String> computeReplacementsForType(JClassType type) {
        IdentityHashMap<JMethod, String> toReturn = new IdentityHashMap<JMethod, String>();
        if (type == null || !this.derivedFromCssResource(type)) {
            return toReturn;
        }
        if (this.replacementsByClassAndMethod.containsKey(type)) {
            toReturn.putAll(this.replacementsByClassAndMethod.get(type));
        }
        for (JMethod method : type.getOverridableMethods()) {
            if (!this.replacementsForSharedMethods.containsKey(method)) continue;
            assert (toReturn.containsKey(method));
            toReturn.put(method, this.replacementsForSharedMethods.get(method));
        }
        return toReturn;
    }

    private boolean derivedFromCssResource(JClassType type) {
        List<JClassType> superInterfaces = Arrays.asList(type.getImplementedInterfaces());
        if (superInterfaces.contains(this.cssResourceType)) {
            return true;
        }
        JClassType superClass = type.getSuperclass();
        if (superClass != null && this.derivedFromCssResource(superClass)) {
            return true;
        }
        for (JClassType superInterface : superInterfaces) {
            if (!this.derivedFromCssResource(superInterface)) continue;
            return true;
        }
        return false;
    }

    private void initReplacements(TreeLogger logger, ResourceContext context, String classPrefix) {
        SortedSet<JClassType> cssResourceSubtypes = this.computeOperableTypes(logger);
        if (context.getCachedData(KEY_HAS_CACHED_DATA, Boolean.class) != Boolean.TRUE) {
            context.putCachedData(KEY_CLASS_COUNTER, new Counter());
            context.putCachedData(KEY_BY_CLASS_AND_METHOD, new IdentityHashMap());
            context.putCachedData(KEY_SHARED_METHODS, new IdentityHashMap());
            context.putCachedData(KEY_CLASS_PREFIX, this.computeClassPrefix(classPrefix, cssResourceSubtypes));
            context.putCachedData(KEY_HAS_CACHED_DATA, Boolean.TRUE);
        }
        this.classCounter = context.getCachedData(KEY_CLASS_COUNTER, Counter.class);
        this.replacementsByClassAndMethod = context.getCachedData(KEY_BY_CLASS_AND_METHOD, Map.class);
        this.replacementsForSharedMethods = context.getCachedData(KEY_SHARED_METHODS, Map.class);
        classPrefix = context.getCachedData(KEY_CLASS_PREFIX, String.class);
        this.computeObfuscatedNames(logger, classPrefix, cssResourceSubtypes);
    }

    private boolean isStrict(TreeLogger logger, ResourceContext context, JMethod method) {
        CssResource.Strict strictAnnotation = (CssResource.Strict)method.getAnnotation(CssResource.Strict.class);
        CssResource.NotStrict nonStrictAnnotation = (CssResource.NotStrict)method.getAnnotation(CssResource.NotStrict.class);
        boolean strict = false;
        if (strictAnnotation != null && nonStrictAnnotation != null) {
            logger.log(TreeLogger.WARN, "Contradictory annotations " + CssResource.Strict.class.getName() + " and " + CssResource.NotStrict.class.getName() + " applied to the CssResource accessor method; assuming strict");
            strict = true;
        } else if (strictAnnotation == null && nonStrictAnnotation == null) {
            try {
                PropertyOracle propertyOracle = context.getGeneratorContext().getPropertyOracle();
                ConfigurationProperty prop = propertyOracle.getConfigurationProperty("CssResource.strictAccessors");
                String propertyValue = (String)prop.getValues().get(0);
                if (Boolean.valueOf(propertyValue).booleanValue()) {
                    logger.log(TreeLogger.WARN, "CssResource.strictAccessors is true, but " + method.getName() + "() is missing the @Strict annotation.");
                    strict = true;
                }
            }
            catch (BadPropertyValueException e) {
                // empty catch block
            }
            if (!strict) {
                logger.log(TreeLogger.WARN, "Accessor does not specify " + CssResource.Strict.class.getName() + " or " + CssResource.NotStrict.class.getName() + ". The default behavior will change from non-strict " + "to strict in a future revision.");
            }
        } else if (nonStrictAnnotation != null) {
            strict = false;
        } else if (strictAnnotation != null) {
            strict = true;
        }
        return strict;
    }

    private String makeExpression(TreeLogger logger, ResourceContext context, JClassType cssResourceType, CssStylesheet sheet, Map<String, Map<JMethod, String>> classReplacementsWithPrefix, boolean strict, Map<JMethod, String> actualReplacements) throws UnableToCompleteException {
        try {
            new Spriter(logger, context).accept(sheet);
            SubstitutionCollector collector = new SubstitutionCollector();
            collector.accept(sheet);
            new SubstitutionReplacer(logger, context, collector.substitutions).accept(sheet);
            new IfEvaluator(logger, context.getGeneratorContext().getPropertyOracle()).accept(sheet);
            ExternalClassesCollector externalClasses = new ExternalClassesCollector();
            externalClasses.accept(sheet);
            ClassRenamer renamer = new ClassRenamer(logger, classReplacementsWithPrefix, strict, externalClasses.getClasses());
            renamer.accept(sheet);
            actualReplacements.putAll(renamer.getReplacements());
            if (this.enableMerge) {
                new SplitRulesVisitor().accept(sheet);
                new MergeIdenticalSelectorsVisitor().accept(sheet);
                new MergeRulesByContentVisitor().accept(sheet);
            }
            String standard = CssResourceGenerator.makeExpression(logger, context, cssResourceType, sheet, this.prettyOutput);
            new RtlVisitor().accept(sheet);
            String reversed = CssResourceGenerator.makeExpression(logger, context, cssResourceType, sheet, this.prettyOutput);
            return LocaleInfo.class.getName() + ".getCurrentLocale().isRTL() ? (" + reversed + ") : (" + standard + ")";
        }
        catch (CssCompilerException e) {
            logger.log(TreeLogger.ERROR, "Unable to process CSS", (Throwable)(e.getCause() == null ? null : e));
            throw new UnableToCompleteException();
        }
    }

    private void writeClassAssignment(SourceWriter sw, JMethod toImplement, Map<JMethod, String> classReplacements) {
        String replacement = classReplacements.get(toImplement);
        assert (replacement != null) : "Missing replacement for " + toImplement.getName();
        sw.println(toImplement.getReadableDeclaration(false, true, true, true, true) + "{");
        sw.indent();
        sw.println("return \"" + replacement + "\";");
        sw.outdent();
        sw.println("}");
    }

    private void writeDefAssignment(TreeLogger logger, SourceWriter sw, JMethod toImplement, CssStylesheet cssStylesheet) throws UnableToCompleteException {
        SubstitutionCollector collector = new SubstitutionCollector();
        collector.accept(cssStylesheet);
        String name = toImplement.getName();
        CssDef def = (CssDef)collector.substitutions.get(name);
        if (def == null) {
            logger.log(TreeLogger.ERROR, "No @def rule for name " + name);
            throw new UnableToCompleteException();
        }
        if (def.getValues().size() != 1) {
            logger.log(TreeLogger.ERROR, "@def rule " + name + " must define exactly one value");
            throw new UnableToCompleteException();
        }
        CssProperty.NumberValue numberValue = def.getValues().get(0).isNumberValue();
        String returnExpr = "";
        JClassType classReturnType = toImplement.getReturnType().isClass();
        if (classReturnType != null && "java.lang.String".equals(classReturnType.getQualifiedSourceName())) {
            returnExpr = "\"" + Generator.escape((String)def.getValues().get(0).toString()) + "\"";
        } else {
            JPrimitiveType returnType = toImplement.getReturnType().isPrimitive();
            if (returnType == null) {
                logger.log(TreeLogger.ERROR, toImplement.getName() + ": Return type must be primitive type or String for " + "@def accessors");
                throw new UnableToCompleteException();
            }
            if (returnType == JPrimitiveType.INT || returnType == JPrimitiveType.LONG) {
                returnExpr = "" + Math.round(numberValue.getValue());
            } else if (returnType == JPrimitiveType.FLOAT) {
                returnExpr = numberValue.getValue() + "F";
            } else if (returnType == JPrimitiveType.DOUBLE) {
                returnExpr = "" + numberValue.getValue();
            } else {
                logger.log(TreeLogger.ERROR, returnType.getQualifiedSourceName() + " is not a valid primitive return type for @def accessors");
                throw new UnableToCompleteException();
            }
        }
        sw.print(toImplement.getReadableDeclaration(false, false, false, false, true));
        sw.println(" {");
        sw.indent();
        sw.println("return " + returnExpr + ";");
        sw.outdent();
        sw.println("}");
    }

    private void writeUserMethods(TreeLogger logger, SourceWriter sw, CssStylesheet sheet, JMethod[] methods, Map<JMethod, String> obfuscatedClassNames) throws UnableToCompleteException {
        DefsCollector collector = new DefsCollector();
        collector.accept(sheet);
        for (JMethod toImplement : methods) {
            String name = toImplement.getName();
            if ("getName".equals(name) || "getText".equals(name)) continue;
            if (collector.defs.contains(name) && obfuscatedClassNames.containsKey(toImplement)) {
                logger.log(TreeLogger.ERROR, "@def shadows CSS class name: " + name + ". Fix by renaming the @def name or the CSS class name.");
                throw new UnableToCompleteException();
            }
            if (collector.defs.contains(toImplement.getName()) && toImplement.getParameters().length == 0) {
                this.writeDefAssignment(logger, sw, toImplement, sheet);
                continue;
            }
            if (toImplement.getReturnType().equals((Object)this.stringType) && toImplement.getParameters().length == 0) {
                this.writeClassAssignment(sw, toImplement, obfuscatedClassNames);
                continue;
            }
            logger.log(TreeLogger.ERROR, "Don't know how to implement method " + toImplement.getName());
            throw new UnableToCompleteException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubstitutionReplacer
    extends CssVisitor {
        private final ResourceContext context;
        private final TreeLogger logger;
        private final Map<String, CssDef> substitutions;

        public SubstitutionReplacer(TreeLogger logger, ResourceContext context, Map<String, CssDef> substitutions) {
            this.context = context;
            this.logger = logger;
            this.substitutions = substitutions;
        }

        @Override
        public void endVisit(CssProperty x, Context ctx) {
            if (x.getValues() == null) {
                return;
            }
            ArrayList<CssProperty.Value> values = new ArrayList<CssProperty.Value>(x.getValues().getValues());
            ListIterator<CssProperty.Value> i = values.listIterator();
            while (i.hasNext()) {
                String value;
                CssDef def;
                CssProperty.IdentValue v = ((CssProperty.Value)i.next()).isIdentValue();
                if (v == null || (def = this.substitutions.get(value = v.getIdent())) == null) continue;
                if (def instanceof CssUrl) {
                    assert (def.getValues().size() == 1);
                    assert (def.getValues().get(0).isIdentValue() != null);
                    String functionName = def.getValues().get(0).isIdentValue().getIdent();
                    JMethod[] methods = this.context.getClientBundleType().getOverridableMethods();
                    boolean foundMethod = false;
                    if (methods != null) {
                        for (JMethod method : methods) {
                            if (!method.getName().equals(functionName)) continue;
                            foundMethod = true;
                            break;
                        }
                    }
                    if (!foundMethod) {
                        this.logger.log(TreeLogger.ERROR, "Unable to find DataResource method " + functionName + " in " + this.context.getClientBundleType().getQualifiedSourceName());
                        throw new CssCompilerException("Cannot find data function");
                    }
                    String instance = "((" + DataResource.class.getName() + ")(" + this.context.getImplementationSimpleSourceName() + ".this." + functionName + "()))";
                    StringBuilder expression = new StringBuilder();
                    expression.append("\"url('\" + ");
                    expression.append(instance).append(".getUrl()");
                    expression.append(" + \"')\"");
                    i.set(new CssProperty.ExpressionValue(expression.toString()));
                    continue;
                }
                i.remove();
                for (CssProperty.Value defValue : def.getValues()) {
                    i.add(defValue);
                }
            }
            x.setValue(new CssProperty.ListValue(values));
        }
    }

    static class SubstitutionCollector
    extends CssVisitor {
        private final Map<String, CssDef> substitutions = new HashMap<String, CssDef>();

        SubstitutionCollector() {
        }

        public void endVisit(CssDef x, Context ctx) {
            this.substitutions.put(x.getKey(), x);
        }

        public void endVisit(CssEval x, Context ctx) {
            this.substitutions.put(x.getKey(), x);
        }

        public void endVisit(CssUrl x, Context ctx) {
            this.substitutions.put(x.getKey(), x);
        }
    }

    static class Spriter
    extends CssModVisitor {
        private final ResourceContext context;
        private final TreeLogger logger;

        public Spriter(TreeLogger logger, ResourceContext context) {
            this.logger = logger.branch(TreeLogger.DEBUG, "Creating image sprite classes");
            this.context = context;
        }

        public void endVisit(CssSprite x, Context ctx) {
            String repeatText;
            JClassType bundleType = this.context.getClientBundleType();
            String functionName = x.getResourceFunction();
            if (functionName == null) {
                this.logger.log(TreeLogger.ERROR, "The @sprite rule " + x.getSelectors() + " must specify the " + "gwt-image" + " property");
                throw new CssCompilerException("No image property specified");
            }
            JMethod imageMethod = null;
            JMethod[] allMethods = bundleType.getOverridableMethods();
            for (int i = 0; imageMethod == null && i < allMethods.length; ++i) {
                JMethod candidate = allMethods[i];
                if (!candidate.getName().equals(functionName) || candidate.getParameters().length != 0) continue;
                imageMethod = candidate;
            }
            if (imageMethod == null) {
                this.logger.log(TreeLogger.ERROR, "Unable to find ImageResource method " + functionName + " in " + bundleType.getQualifiedSourceName());
                throw new CssCompilerException("Cannot find image function");
            }
            JClassType imageResourceType = this.context.getGeneratorContext().getTypeOracle().findType(ImageResource.class.getName());
            assert (imageResourceType != null);
            if (!imageResourceType.isAssignableFrom(imageMethod.getReturnType().isClassOrInterface())) {
                this.logger.log(TreeLogger.ERROR, "The return type of " + functionName + " is not assignable to " + imageResourceType.getSimpleSourceName());
                throw new CssCompilerException("Incorrect return type for gwt-image method");
            }
            ImageResource.ImageOptions options = (ImageResource.ImageOptions)imageMethod.getAnnotation(ImageResource.ImageOptions.class);
            ImageResource.RepeatStyle repeatStyle = options != null ? options.repeatStyle() : ImageResource.RepeatStyle.None;
            String instance = "(" + this.context.getImplementationSimpleSourceName() + ".this." + functionName + "())";
            CssRule replacement = new CssRule();
            replacement.getSelectors().addAll(x.getSelectors());
            List<CssProperty> properties = replacement.getProperties();
            if (repeatStyle == ImageResource.RepeatStyle.None || repeatStyle == ImageResource.RepeatStyle.Horizontal) {
                properties.add(new CssProperty("height", new CssProperty.ExpressionValue(instance + ".getHeight() + \"px\""), false));
            }
            if (repeatStyle == ImageResource.RepeatStyle.None || repeatStyle == ImageResource.RepeatStyle.Vertical) {
                properties.add(new CssProperty("width", new CssProperty.ExpressionValue(instance + ".getWidth() + \"px\""), false));
            }
            properties.add(new CssProperty("overflow", new CssProperty.IdentValue("hidden"), false));
            switch (repeatStyle) {
                case None: {
                    repeatText = " no-repeat";
                    break;
                }
                case Horizontal: {
                    repeatText = " repeat-x";
                    break;
                }
                case Vertical: {
                    repeatText = " repeat-y";
                    break;
                }
                case Both: {
                    repeatText = " repeat";
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown repeatStyle " + (Object)((Object)repeatStyle));
                }
            }
            String backgroundExpression = "\"url(\\\"\" + " + instance + ".getURL() + \"\\\") -\" + " + instance + ".getLeft() + \"px -\" + " + instance + ".getTop() + \"px " + repeatText + "\"";
            properties.add(new CssProperty("background", new CssProperty.ExpressionValue(backgroundExpression), false));
            properties.addAll(x.getProperties());
            ctx.replaceMe(replacement);
        }
    }

    static class SplitRulesVisitor
    extends CssModVisitor {
        SplitRulesVisitor() {
        }

        public void endVisit(CssRule x, Context ctx) {
            if (x.getSelectors().size() == 1) {
                return;
            }
            for (CssSelector sel : x.getSelectors()) {
                CssRule newRule = new CssRule();
                newRule.getSelectors().add(sel);
                newRule.getProperties().addAll(CssNodeCloner.clone(CssProperty.class, x.getProperties()));
                ctx.insertBefore(newRule);
            }
            ctx.removeMe();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RtlVisitor
    extends CssModVisitor {
        private boolean inBodyRule;

        RtlVisitor() {
        }

        @Override
        public void endVisit(CssProperty x, Context ctx) {
            String name = x.getName();
            if (name.equalsIgnoreCase("left")) {
                x.setName("right");
            } else if (name.equalsIgnoreCase("right")) {
                x.setName("left");
            } else if (name.endsWith("-left")) {
                int len = name.length();
                x.setName(name.substring(0, len - 4) + "right");
            } else if (name.endsWith("-right")) {
                int len = name.length();
                x.setName(name.substring(0, len - 5) + "left");
            } else if (name.contains("-right-")) {
                x.setName(name.replace("-right-", "-left-"));
            } else if (name.contains("-left-")) {
                x.setName(name.replace("-left-", "-right-"));
            } else {
                ArrayList<CssProperty.Value> values = new ArrayList<CssProperty.Value>(x.getValues().getValues());
                this.invokePropertyHandler(x.getName(), values);
                x.setValue(new CssProperty.ListValue(values));
            }
        }

        @Override
        public boolean visit(CssNoFlip x, Context ctx) {
            return false;
        }

        @Override
        public boolean visit(CssRule x, Context ctx) {
            this.inBodyRule = x.getSelectors().size() == 1 && x.getSelectors().get(0).getSelector().equals("body");
            return true;
        }

        void propertyHandlerBackground(List<CssProperty.Value> values) {
            boolean seenLeft = false;
            ListIterator<CssProperty.Value> it = values.listIterator();
            while (it.hasNext()) {
                CssProperty.Value v = it.next();
                CssProperty.Value maybeFlipped = this.flipLeftRightIdentValue(v);
                CssProperty.NumberValue nv = v.isNumberValue();
                if (v != maybeFlipped) {
                    it.set(maybeFlipped);
                    seenLeft = true;
                    continue;
                }
                if (this.isIdent(v, "center")) {
                    seenLeft = true;
                    continue;
                }
                if (seenLeft || nv == null) continue;
                seenLeft = true;
                if (!"%".equals(nv.getUnits())) continue;
                float position = 100.0f - nv.getValue();
                it.set(new CssProperty.NumberValue(position, "%"));
                break;
            }
        }

        void propertyHandlerBackgroundPosition(List<CssProperty.Value> values) {
            this.propertyHandlerBackground(values);
        }

        CssProperty.Value propertyHandlerBackgroundPositionX(CssProperty.Value v) {
            ArrayList<CssProperty.Value> list = new ArrayList<CssProperty.Value>(1);
            list.add(v);
            this.propertyHandlerBackground(list);
            return list.get(0);
        }

        void propertyHandlerBorderColor(List<CssProperty.Value> values) {
            this.swapFour(values);
        }

        void propertyHandlerBorderStyle(List<CssProperty.Value> values) {
            this.swapFour(values);
        }

        void propertyHandlerBorderWidth(List<CssProperty.Value> values) {
            this.swapFour(values);
        }

        CssProperty.Value propertyHandlerClear(CssProperty.Value v) {
            return this.propertyHandlerFloat(v);
        }

        CssProperty.Value propertyHandlerCursor(CssProperty.Value v) {
            CssProperty.IdentValue identValue = v.isIdentValue();
            if (identValue == null) {
                return v;
            }
            String ident = identValue.getIdent().toLowerCase();
            if (!ident.endsWith("-resize")) {
                return v;
            }
            StringBuffer newIdent = new StringBuffer();
            if (ident.length() == 9) {
                if (ident.charAt(0) == 'n') {
                    newIdent.append('n');
                    ident = ident.substring(1);
                } else if (ident.charAt(0) == 's') {
                    newIdent.append('s');
                    ident = ident.substring(1);
                } else {
                    return v;
                }
            }
            if (ident.length() == 8) {
                if (ident.charAt(0) == 'e') {
                    newIdent.append("w-resize");
                } else if (ident.charAt(0) == 'w') {
                    newIdent.append("e-resize");
                } else {
                    return v;
                }
                return new CssProperty.IdentValue(newIdent.toString());
            }
            return v;
        }

        CssProperty.Value propertyHandlerDirection(CssProperty.Value v) {
            if (this.inBodyRule) {
                if (this.isIdent(v, "ltr")) {
                    return new CssProperty.IdentValue("rtl");
                }
                if (this.isIdent(v, "rtl")) {
                    return new CssProperty.IdentValue("ltr");
                }
            }
            return v;
        }

        CssProperty.Value propertyHandlerFloat(CssProperty.Value v) {
            return this.flipLeftRightIdentValue(v);
        }

        void propertyHandlerMargin(List<CssProperty.Value> values) {
            this.swapFour(values);
        }

        void propertyHandlerPadding(List<CssProperty.Value> values) {
            this.swapFour(values);
        }

        CssProperty.Value propertyHandlerPageBreakAfter(CssProperty.Value v) {
            return this.flipLeftRightIdentValue(v);
        }

        CssProperty.Value propertyHandlerPageBreakBefore(CssProperty.Value v) {
            return this.flipLeftRightIdentValue(v);
        }

        CssProperty.Value propertyHandlerTextAlign(CssProperty.Value v) {
            return this.flipLeftRightIdentValue(v);
        }

        private CssProperty.Value flipLeftRightIdentValue(CssProperty.Value v) {
            if (this.isIdent(v, "right")) {
                return new CssProperty.IdentValue("left");
            }
            if (this.isIdent(v, "left")) {
                return new CssProperty.IdentValue("right");
            }
            return v;
        }

        private void invokePropertyHandler(String name, List<CssProperty.Value> values) {
            try {
                Method m;
                String[] parts = name.toLowerCase().split("-");
                StringBuffer methodName = new StringBuffer("propertyHandler");
                for (String part : parts) {
                    methodName.append(Character.toUpperCase(part.charAt(0)));
                    methodName.append(part, 1, part.length());
                }
                try {
                    m = this.getClass().getDeclaredMethod(methodName.toString(), CssProperty.Value.class);
                    assert (CssProperty.Value.class.isAssignableFrom(m.getReturnType()));
                    CssProperty.Value newValue = (CssProperty.Value)m.invoke((Object)this, values.get(0));
                    values.set(0, newValue);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                try {
                    m = this.getClass().getDeclaredMethod(methodName.toString(), List.class);
                    m.invoke((Object)this, values);
                }
                catch (NoSuchMethodException e) {}
            }
            catch (SecurityException e) {
                throw new CssCompilerException("Unable to invoke property handler function for " + name, e);
            }
            catch (IllegalArgumentException e) {
                throw new CssCompilerException("Unable to invoke property handler function for " + name, e);
            }
            catch (IllegalAccessException e) {
                throw new CssCompilerException("Unable to invoke property handler function for " + name, e);
            }
            catch (InvocationTargetException e) {
                throw new CssCompilerException("Unable to invoke property handler function for " + name, e);
            }
        }

        private boolean isIdent(CssProperty.Value value, String query) {
            CssProperty.IdentValue v = value.isIdentValue();
            return v != null && v.getIdent().equalsIgnoreCase(query);
        }

        private void swapFour(List<CssProperty.Value> values) {
            if (values.size() == 4) {
                Collections.swap(values, 1, 3);
            }
        }
    }

    static class RequirementsCollector
    extends CssVisitor {
        private final TreeLogger logger;
        private final ClientBundleRequirements requirements;

        public RequirementsCollector(TreeLogger logger, ClientBundleRequirements requirements) {
            this.logger = logger.branch(TreeLogger.DEBUG, "Scanning CSS for requirements");
            this.requirements = requirements;
        }

        public void endVisit(CssIf x, Context ctx) {
            String propertyName = x.getPropertyName();
            if (propertyName != null) {
                try {
                    this.requirements.addPermutationAxis(propertyName);
                }
                catch (BadPropertyValueException e) {
                    this.logger.log(TreeLogger.ERROR, "Unknown deferred-binding property " + propertyName, (Throwable)e);
                    throw new CssCompilerException("Unknown deferred-binding property", e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MergeRulesByContentVisitor
    extends CssModVisitor {
        private Map<String, CssRule> rulesByContents = new HashMap<String, CssRule>();
        private final List<CssRule> rulesInOrder = new ArrayList<CssRule>();

        MergeRulesByContentVisitor() {
        }

        @Override
        public boolean visit(CssIf x, Context ctx) {
            this.visitInNewContext(x.getNodes());
            this.visitInNewContext(x.getElseNodes());
            return false;
        }

        @Override
        public boolean visit(CssMediaRule x, Context ctx) {
            this.visitInNewContext(x.getNodes());
            return false;
        }

        @Override
        public boolean visit(CssRule x, Context ctx) {
            StringBuilder b = new StringBuilder();
            for (CssProperty p : x.getProperties()) {
                b.append(p.getName()).append(":").append(p.getValues().getExpression());
            }
            String content = b.toString();
            CssRule canonical = this.rulesByContents.get(content);
            if (canonical != null) {
                boolean hasCommon = false;
                int index = this.rulesInOrder.indexOf(canonical) + 1;
                assert (index != 0);
                ListIterator<CssRule> i = this.rulesInOrder.listIterator(index);
                while (i.hasNext() && !hasCommon) {
                    hasCommon = CssResourceGenerator.haveCommonProperties((CssRule)i.next(), x);
                }
                if (!hasCommon) {
                    canonical.getSelectors().addAll(x.getSelectors());
                    ctx.removeMe();
                    return false;
                }
            }
            this.rulesByContents.put(content, x);
            this.rulesInOrder.add(x);
            return false;
        }

        private void visitInNewContext(List<CssNode> nodes) {
            MergeRulesByContentVisitor v = new MergeRulesByContentVisitor();
            v.acceptWithInsertRemove(nodes);
            this.rulesInOrder.addAll(v.rulesInOrder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MergeIdenticalSelectorsVisitor
    extends CssModVisitor {
        private final Map<String, CssRule> canonicalRules = new HashMap<String, CssRule>();
        private final List<CssRule> rulesInOrder = new ArrayList<CssRule>();

        MergeIdenticalSelectorsVisitor() {
        }

        @Override
        public boolean visit(CssIf x, Context ctx) {
            this.visitInNewContext(x.getNodes());
            this.visitInNewContext(x.getElseNodes());
            return false;
        }

        @Override
        public boolean visit(CssMediaRule x, Context ctx) {
            this.visitInNewContext(x.getNodes());
            return false;
        }

        @Override
        public boolean visit(CssRule x, Context ctx) {
            assert (x.getSelectors().size() == 1);
            CssSelector sel = x.getSelectors().get(0);
            if (this.canonicalRules.containsKey(sel.getSelector())) {
                CssRule canonical = this.canonicalRules.get(sel.getSelector());
                boolean hasCommon = false;
                int index = this.rulesInOrder.indexOf(canonical) + 1;
                assert (index != 0);
                ListIterator<CssRule> i = this.rulesInOrder.listIterator(index);
                while (i.hasNext() && !hasCommon) {
                    hasCommon = CssResourceGenerator.haveCommonProperties((CssRule)i.next(), x);
                }
                if (!hasCommon) {
                    canonical.getProperties().addAll(x.getProperties());
                    ctx.removeMe();
                    return false;
                }
            }
            this.canonicalRules.put(sel.getSelector(), x);
            this.rulesInOrder.add(x);
            return false;
        }

        private void visitInNewContext(List<CssNode> nodes) {
            MergeIdenticalSelectorsVisitor v = new MergeIdenticalSelectorsVisitor();
            v.acceptWithInsertRemove(nodes);
            this.rulesInOrder.addAll(v.rulesInOrder);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JClassOrderComparator
    implements Comparator<JClassType>,
    Serializable {
        JClassOrderComparator() {
        }

        @Override
        public int compare(JClassType o1, JClassType o2) {
            return o1.getQualifiedSourceName().compareTo(o2.getQualifiedSourceName());
        }
    }

    static class IfEvaluator
    extends CssModVisitor {
        private final TreeLogger logger;
        private final PropertyOracle oracle;

        public IfEvaluator(TreeLogger logger, PropertyOracle oracle) {
            this.logger = logger.branch(TreeLogger.DEBUG, "Replacing property-based @if blocks");
            this.oracle = oracle;
        }

        public void endVisit(CssIf x, Context ctx) {
            if (x.getExpression() == null) {
                try {
                    String propertyName = x.getPropertyName();
                    String propValue = null;
                    try {
                        SelectionProperty selProp = this.oracle.getSelectionProperty(this.logger, propertyName);
                        propValue = selProp.getCurrentValue();
                    }
                    catch (BadPropertyValueException e) {
                        ConfigurationProperty confProp = this.oracle.getConfigurationProperty(propertyName);
                        propValue = (String)confProp.getValues().get(0);
                    }
                    if (Arrays.asList(x.getPropertyValues()).contains(propValue) ^ x.isNegated()) {
                        for (CssNode n : x.getNodes()) {
                            ctx.insertBefore(n);
                        }
                    } else {
                        for (CssNode n : x.getElseNodes()) {
                            ctx.insertBefore(n);
                        }
                    }
                    ctx.removeMe();
                }
                catch (BadPropertyValueException e) {
                    this.logger.log(TreeLogger.ERROR, "Unable to evaluate @if block", (Throwable)e);
                    throw new CssCompilerException("Unable to parse CSS", e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExternalClassesCollector
    extends CssVisitor {
        private final Set<String> classes = new HashSet<String>();

        ExternalClassesCollector() {
        }

        @Override
        public void endVisit(CssExternalSelectors x, Context ctx) {
            this.classes.addAll(x.getClasses());
        }

        public Set<String> getClasses() {
            return this.classes;
        }
    }

    static class DefsCollector
    extends CssVisitor {
        private final Set<String> defs = new HashSet<String>();

        DefsCollector() {
        }

        public void endVisit(CssDef x, Context ctx) {
            this.defs.add(x.getKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClassRenamer
    extends CssVisitor {
        private static final Replacement UNREFERENCED_EXTERNAL = new Replacement(null, null);
        private final Map<JMethod, String> actualReplacements = new IdentityHashMap<JMethod, String>();
        private final Set<String> cssDefs = new HashSet<String>();
        private final Map<String, Replacement> potentialReplacements;
        private final TreeLogger logger;
        private final Set<JMethod> missingClasses;
        private final boolean strict;
        private final Set<String> unknownClasses = new HashSet<String>();

        public ClassRenamer(TreeLogger logger, Map<String, Map<JMethod, String>> classReplacementsWithPrefix, boolean strict, Set<String> externalClasses) {
            this.logger = logger.branch(TreeLogger.DEBUG, "Replacing CSS class names");
            this.strict = strict;
            this.potentialReplacements = this.computeReplacements(classReplacementsWithPrefix, externalClasses);
            assert (classReplacementsWithPrefix.containsKey(""));
            this.missingClasses = new HashSet<JMethod>(classReplacementsWithPrefix.get("").keySet());
        }

        @Override
        public void endVisit(CssDef x, Context ctx) {
            this.cssDefs.add(x.getKey());
        }

        @Override
        public void endVisit(CssSelector x, Context ctx) {
            String sel = x.getSelector();
            int originalLength = sel.length();
            Matcher ma = CssSelector.CLASS_SELECTOR_PATTERN.matcher(sel);
            StringBuilder sb = new StringBuilder(originalLength);
            int start = 0;
            while (ma.find()) {
                String sourceClassName = ma.group(1);
                Replacement entry = this.potentialReplacements.get(sourceClassName);
                if (entry == null) {
                    this.unknownClasses.add(sourceClassName);
                    continue;
                }
                if (entry == UNREFERENCED_EXTERNAL) continue;
                JMethod method = entry.getMethod();
                String obfuscatedClassName = entry.getObfuscatedClassName();
                sb.append(sel.subSequence(start, ma.start(1)));
                sb.append(obfuscatedClassName);
                start = ma.end(1);
                this.actualReplacements.put(method, obfuscatedClassName);
                this.missingClasses.remove(method);
            }
            if (start != 0) {
                sb.append(sel.subSequence(start, originalLength));
                x.setSelector(sb.toString());
            }
        }

        @Override
        public void endVisit(CssStylesheet x, Context ctx) {
            TreeLogger errorLogger;
            boolean stop = false;
            ArrayList<JMethod> toRemove = new ArrayList<JMethod>();
            for (JMethod method : this.missingClasses) {
                if (!this.cssDefs.contains(method.getName())) continue;
                toRemove.add(method);
            }
            for (JMethod method : toRemove) {
                this.missingClasses.remove(method);
            }
            if (!this.missingClasses.isEmpty()) {
                stop = true;
                errorLogger = this.logger.branch(TreeLogger.INFO, "The following obfuscated style classes were missing from the source CSS file:");
                for (JMethod m : this.missingClasses) {
                    String name = m.getName();
                    CssResource.ClassName className = (CssResource.ClassName)m.getAnnotation(CssResource.ClassName.class);
                    if (className != null) {
                        name = className.value();
                    }
                    errorLogger.log(TreeLogger.ERROR, name + ": Fix by adding ." + name + "{}");
                }
            }
            if (this.strict && !this.unknownClasses.isEmpty()) {
                stop = true;
                errorLogger = this.logger.branch(TreeLogger.ERROR, "The following unobfuscated classes were present in a strict CssResource:");
                for (String s : this.unknownClasses) {
                    errorLogger.log(TreeLogger.ERROR, s);
                }
                errorLogger.log(TreeLogger.INFO, "Fix by adding String accessor method(s) to the CssResource interface for obfuscated classes, or using an @external declaration for unobfuscated classes.");
            }
            if (stop) {
                throw new CssCompilerException("Missing a CSS replacement");
            }
        }

        public Map<JMethod, String> getReplacements() {
            return this.actualReplacements;
        }

        private Map<String, Replacement> computeReplacements(Map<String, Map<JMethod, String>> classReplacementsWithPrefix, Set<String> externalClasses) {
            HashMap<String, Replacement> toReturn = new HashMap<String, Replacement>();
            for (String string : externalClasses) {
                toReturn.put(string, UNREFERENCED_EXTERNAL);
            }
            for (Map.Entry entry : classReplacementsWithPrefix.entrySet()) {
                String prefix = (String)entry.getKey();
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    JMethod method = (JMethod)entry2.getKey();
                    String sourceClassName = method.getName();
                    String obfuscatedClassName = (String)entry2.getValue();
                    CssResource.ClassName className = (CssResource.ClassName)method.getAnnotation(CssResource.ClassName.class);
                    if (className != null) {
                        sourceClassName = className.value();
                    }
                    if (externalClasses.contains(sourceClassName = prefix + sourceClassName)) {
                        obfuscatedClassName = sourceClassName;
                    }
                    toReturn.put(sourceClassName, new Replacement(method, obfuscatedClassName));
                }
            }
            return Collections.unmodifiableMap(toReturn);
        }

        private static class Replacement {
            private JMethod method;
            private String obfuscatedClassName;

            public Replacement(JMethod method, String obfuscatedClassName) {
                this.method = method;
                this.obfuscatedClassName = obfuscatedClassName;
            }

            public JMethod getMethod() {
                return this.method;
            }

            public String getObfuscatedClassName() {
                return this.obfuscatedClassName;
            }

            public String toString() {
                if (this == UNREFERENCED_EXTERNAL) {
                    return "Unreferenced external class name";
                }
                return this.method.getName() + "=" + this.obfuscatedClassName;
            }
        }
    }
}

