/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.parsers.ElementParser;
import com.google.gwt.uibinder.parsers.HorizontalAlignmentConstantParser;
import com.google.gwt.uibinder.parsers.StringAttributeParser;
import com.google.gwt.uibinder.parsers.VerticalAlignmentConstantParser;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;

public class CellPanelParser
implements ElementParser {
    private static final String HALIGN_ATTR = "horizontalAlignment";
    private static final String VALIGN_ATTR = "verticalAlignment";
    private static final String WIDTH_ATTR = "width";
    private static final String HEIGHT_ATTR = "height";
    private static final String CELL_TAG = "Cell";
    private static HorizontalAlignmentConstantParser halignParser = new HorizontalAlignmentConstantParser();
    private static VerticalAlignmentConstantParser valignParser = new VerticalAlignmentConstantParser();
    private static StringAttributeParser stringParser = new StringAttributeParser();

    public static void parseCellAttributes(XMLElement cellElem, String fieldName, String childFieldName, UiBinderWriter writer) throws UnableToCompleteException {
        String value;
        if (cellElem.hasAttribute(HALIGN_ATTR)) {
            value = halignParser.parse(cellElem.consumeAttribute(HALIGN_ATTR), writer);
            writer.addStatement("%1$s.setCellHorizontalAlignment(%2$s, %3$s);", new Object[]{fieldName, childFieldName, value});
        }
        if (cellElem.hasAttribute(VALIGN_ATTR)) {
            value = valignParser.parse(cellElem.consumeAttribute(VALIGN_ATTR), writer);
            writer.addStatement("%1$s.setCellVerticalAlignment(%2$s, %3$s);", new Object[]{fieldName, childFieldName, value});
        }
        if (cellElem.hasAttribute(WIDTH_ATTR)) {
            value = stringParser.parse(cellElem.consumeAttribute(WIDTH_ATTR), writer);
            writer.addStatement("%1$s.setCellWidth(%2$s, %3$s);", new Object[]{fieldName, childFieldName, value});
        }
        if (cellElem.hasAttribute(HEIGHT_ATTR)) {
            value = stringParser.parse(cellElem.consumeAttribute(HEIGHT_ATTR), writer);
            writer.addStatement("%1$s.setCellHeight(%2$s, %3$s);", new Object[]{fieldName, childFieldName, value});
        }
    }

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        for (XMLElement child : elem.consumeChildElements()) {
            String ns = child.getNamespaceUri();
            String tagName = child.getLocalName();
            if (ns.equals(elem.getNamespaceUri()) && tagName.equals(CELL_TAG)) {
                XMLElement widget = child.consumeSingleChildElement();
                if (widget == null) {
                    writer.die("Cell must contain a single child widget");
                }
                String childFieldName = writer.parseElementToField(widget);
                writer.addStatement("%1$s.add(%2$s);", new Object[]{fieldName, childFieldName});
                CellPanelParser.parseCellAttributes(child, fieldName, childFieldName, writer);
                continue;
            }
            String childFieldName = writer.parseElementToField(child);
            writer.addStatement("%1$s.add(%2$s);", new Object[]{fieldName, childFieldName});
        }
    }
}

