/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.parsers.ElementParser;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.DisclosurePanel;

public class DisclosurePanelParser
implements ElementParser {
    private static final String ATTRIBUTE_HEADER_WIDGET = "DisclosurePanel-header";
    private static final String ATTRIBUTE_HEADER_BUNDLE = "imageBundle";
    private static final String ATTRIBUTE_INITIALLY_OPEN = "initiallyOpen";
    private static final String ATTRIBUTE_ENABLE_ANIMATION = "enableAnimation";

    private static JClassType getDisclosurePanelClass(UiBinderWriter w) {
        return w.getOracle().findType(DisclosurePanel.class.getName());
    }

    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        String text = null;
        if (elem.hasAttribute("text")) {
            text = elem.consumeAttribute("text");
            text = '\"' + UiBinderWriter.escapeTextForJavaStringLiteral((String)text) + '\"';
        }
        String imageBundle = null;
        if (elem.hasAttribute(ATTRIBUTE_HEADER_BUNDLE)) {
            imageBundle = elem.consumeAttribute(ATTRIBUTE_HEADER_BUNDLE);
        }
        String initiallyOpen = "false";
        if (elem.hasAttribute(ATTRIBUTE_INITIALLY_OPEN)) {
            initiallyOpen = elem.consumeAttribute(ATTRIBUTE_INITIALLY_OPEN);
        }
        String enableAnimation = "true";
        if (elem.hasAttribute(ATTRIBUTE_ENABLE_ANIMATION)) {
            enableAnimation = elem.consumeAttribute(ATTRIBUTE_ENABLE_ANIMATION);
        }
        String childFieldName = null;
        String headerFieldName = null;
        for (XMLElement child : elem.consumeChildElements()) {
            boolean childIsHeader = false;
            String headerAttributeName = elem.getPrefix() + ":" + ATTRIBUTE_HEADER_WIDGET;
            if (child.hasAttribute(headerAttributeName)) {
                if (headerFieldName != null) {
                    writer.die("In %s, DisclosurePanel cannot contain more than one header widget.", new Object[]{elem});
                }
                child.consumeAttribute(headerAttributeName);
                headerFieldName = writer.parseElementToField(child);
                childIsHeader = true;
            }
            if (childIsHeader) continue;
            if (childFieldName != null) {
                writer.die("In %s, DisclosurePanel cannot contain more than one content widget.", new Object[]{elem});
            }
            childFieldName = writer.parseElementToField(child);
        }
        if (imageBundle != null) {
            writer.setFieldInitializerAsConstructor(fieldName, DisclosurePanelParser.getDisclosurePanelClass(writer), new String[]{imageBundle, text != null ? text : "\"\"", initiallyOpen});
        } else {
            JClassType panelClass = DisclosurePanelParser.getDisclosurePanelClass(writer);
            if (text != null) {
                writer.setFieldInitializerAsConstructor(fieldName, panelClass, new String[]{text});
            } else {
                writer.setFieldInitializerAsConstructor(fieldName, panelClass, new String[0]);
            }
        }
        if (childFieldName != null) {
            writer.addStatement("%1$s.setContent(%2$s);", new Object[]{fieldName, childFieldName});
        }
        if (headerFieldName != null) {
            writer.addStatement("%1$s.setHeader(%2$s);", new Object[]{fieldName, headerFieldName});
        }
        writer.addStatement("%1$s.setAnimationEnabled(%2$s);", new Object[]{fieldName, enableAnimation});
        writer.addStatement("%1$s.setOpen(%2$s);", new Object[]{fieldName, initiallyOpen});
    }
}

