/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.parsers.ElementParser;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DockLayoutPanelParser
implements ElementParser {
    private static final Map<String, String> DOCK_NAMES = new HashMap<String, String>();

    static String getFullyQualifiedEnumName(Enum<?> e) {
        Class<?> cls = e.getClass();
        String clsName = cls.getCanonicalName();
        if (clsName == null) {
            clsName = cls.getSuperclass().getCanonicalName();
        }
        return clsName + "." + e.name();
    }

    @Override
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        if (type != this.getSplitLayoutPanelType(writer)) {
            Style.Unit unit = (Style.Unit)elem.consumeEnumAttribute("unit", Style.Unit.class);
            writer.setFieldInitializerAsConstructor(fieldName, writer.getOracle().findType(DockLayoutPanel.class.getName()), new String[]{DockLayoutPanelParser.getFullyQualifiedEnumName(unit)});
        }
        for (XMLElement child : elem.consumeChildElements()) {
            if (!this.isValidChildElement(elem, child)) {
                writer.die("In %s, child must be one of {north, south, east, west, center}", new Object[]{elem});
            }
            XMLElement widget = child.consumeSingleChildElement();
            String childFieldName = writer.parseElementToField(widget);
            if (this.requiresSize(child)) {
                double size = child.consumeDoubleAttribute("size");
                writer.addStatement("%s.%s(%s, %f);", new Object[]{fieldName, this.addMethodName(child), childFieldName, size});
                continue;
            }
            writer.addStatement("%s.%s(%s);", new Object[]{fieldName, this.addMethodName(child), childFieldName});
        }
        writer.addStatement("%s.layout();", new Object[]{fieldName});
    }

    private String addMethodName(XMLElement elem) {
        return DOCK_NAMES.get(elem.getLocalName());
    }

    private JClassType getSplitLayoutPanelType(UiBinderWriter writer) throws UnableToCompleteException {
        try {
            return writer.getOracle().getType(SplitLayoutPanel.class.getName());
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private boolean isValidChildElement(XMLElement parent, XMLElement child) {
        return child.getNamespaceUri().equals(parent.getNamespaceUri()) && DOCK_NAMES.containsKey(child.getLocalName());
    }

    private boolean requiresSize(XMLElement elem) {
        return !elem.getLocalName().equals("center");
    }

    static {
        DOCK_NAMES.put("north", "addNorth");
        DOCK_NAMES.put("south", "addSouth");
        DOCK_NAMES.put("east", "addEast");
        DOCK_NAMES.put("west", "addWest");
        DOCK_NAMES.put("center", "add");
    }
}

