/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.parsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WidgetInterpreter
implements XMLElement.PostProcessingInterpreter<String> {
    private static final Map<String, String> LEGAL_CHILD_ELEMENTS;
    private static final String DEFAULT_CHILD_ELEMENT = "span";
    private final Map<String, XMLElement> idToWidgetElement = new HashMap<String, XMLElement>();
    private final String fieldName;
    private final UiBinderWriter uiWriter;

    private static String getLegalPlaceholderTag(XMLElement elem) {
        XMLElement parent = elem.getParent();
        String tag = null;
        if (parent != null) {
            tag = LEGAL_CHILD_ELEMENTS.get(parent.getLocalName());
        }
        if (tag == null) {
            tag = DEFAULT_CHILD_ELEMENT;
        }
        return tag;
    }

    public WidgetInterpreter(String fieldName, UiBinderWriter writer) {
        this.fieldName = fieldName;
        this.uiWriter = writer;
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        if (this.uiWriter.isWidgetElement(elem)) {
            String idHolder = this.uiWriter.declareDomIdHolder();
            this.idToWidgetElement.put(idHolder, elem);
            String tag = WidgetInterpreter.getLegalPlaceholderTag(elem);
            return "<" + tag + " id='\" + " + idHolder + " + \"'></" + tag + ">";
        }
        return null;
    }

    public String postProcess(String consumedHtml) throws UnableToCompleteException {
        for (String idHolder : this.idToWidgetElement.keySet()) {
            XMLElement childElem = this.idToWidgetElement.get(idHolder);
            String childField = this.uiWriter.parseElementToField(childElem);
            this.uiWriter.addInitStatement("%1$s.addAndReplaceElement(%2$s, %3$s);", new Object[]{this.fieldName, childField, idHolder});
        }
        return consumedHtml;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("table", "tbody");
        map.put("thead", "tr");
        map.put("tbody", "tr");
        map.put("tfoot", "tr");
        map.put("ul", "li");
        map.put("ol", "li");
        map.put("dl", "dt");
        LEGAL_CHILD_ELEMENTS = Collections.unmodifiableMap(map);
    }
}

