﻿//------------------------------------------------------------------------------
//      Copyright (c) 2009 Mpoware SARL.  All rights reserved.
//      Author: Frédéric QUEUDRET
//
//      The use and distribution terms for this software are contained in the file
//      named license.txt, which can be found in the root of this distribution.
//      By using this software in any fashion, you are agreeing to be bound by the
//      terms of this license.
//     
//      You must not remove this notice, or any other, from this software.
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Security.Cryptography;
using System.IO;

namespace ProtectAsm
{
    class Program
    {
        static void Main(string[] args)
        {
            string asmPath = args[0];
            string password = args[1];            

            string[] asmPathParts = asmPath.Split('.');
            asmPathParts[asmPathParts.Length - 1] = "Crypted.dll";
            string cryptedAsmPath = string.Join(".", asmPathParts);

            // Génération d'un mot de passe
            PasswordDeriveBytes pwdGen = new PasswordDeriveBytes(password, MD5CryptoServiceProvider.Create().ComputeHash(Encoding.UTF8.GetBytes(password)));
            byte[] key = pwdGen.GetBytes(16);
            byte[] vector = pwdGen.GetBytes(8);

            Console.WriteLine("key:{0}; vector:{1}", Convert.ToBase64String(key), Convert.ToBase64String(vector));

            // Chiffrement à l'aide de Triple-DES
            TripleDESCryptoServiceProvider provider = new TripleDESCryptoServiceProvider();
            provider.Key = key;
            provider.IV = vector;
            provider.Padding = PaddingMode.PKCS7;
           
            using (FileStream outFsStream = File.Create(cryptedAsmPath))
            {
                using (CryptoStream stream = new CryptoStream(outFsStream, provider.CreateEncryptor(), CryptoStreamMode.Write))
                {
                    BinaryReader reader = new BinaryReader(File.Open(asmPath, FileMode.Open));                    
                    int length = 256;
                    byte[] buffer = new byte[length];
                    while (reader.Read(buffer, 0, length) > 0)
                    {
                        stream.Write(buffer, 0, length);
                    }
                    reader.Close();
                    stream.Flush();
                    stream.FlushFinalBlock();
                }
            }

            Console.ReadLine();
        }
    }
}
