﻿//------------------------------------------------------------------------------
//      Copyright (c) 2009 Mpoware SARL.  All rights reserved.
//      Author: Frédéric QUEUDRET
//
//      The use and distribution terms for this software are contained in the file
//      named license.txt, which can be found in the root of this distribution.
//      By using this software in any fashion, you are agreeing to be bound by the
//      terms of this license.
//     
//      You must not remove this notice, or any other, from this software.
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using System.Security;
using System.Diagnostics;

namespace ProtectedLib
{    
    public class SecretClass
    {
        private const string GrantedCallingAssembly = "ACQAAASAAACUAAAABgIAAAAkAABSU0ExAAQAAAEAAQBp6Voly5lr8Ev2EsqWElV+oKssgUQLnzf/uhBg4taWbfZN/PbYM+cPkp86DR+TCUhuszThwd1CSM9yKa5Xb0DQ5sHm876Xz/6XhbJAdNor8MSy/IVy84BYz5wvFYI6kmbuSOO49YwNiZFS5wx25rc/WTwMIXUb4mFFkBdAqmm5tA==";
        private bool _isGranted;

        public SecretClass()
        {
            _isGranted = false;
            // Récupération des informations de l'assembly appelante
            AssemblyName callingAsm = Assembly.GetEntryAssembly().GetName();
            // Vérification de l'identité de l'assembly appelante
            if (Convert.ToBase64String(callingAsm.GetPublicKey()) == GrantedCallingAssembly)
            {
                _isGranted = true;
            }
        }

        public int Calculate(int value, int power)
        {
            // Vérifier si l'appelant est bien celui qu'il prétend être
            if (!_isGranted)
            {
                throw new SecurityException();
            }
            int res = 1;
            for (int i = 0; i < power; i++)
            {
                res = res * value;
            }
            return res;
        }
    }
}
