﻿//------------------------------------------------------------------------------
//      Copyright (c) 2009 Mpoware SARL.  All rights reserved.
//      Author: Frédéric QUEUDRET
//
//      The use and distribution terms for this software are contained in the file
//      named license.txt, which can be found in the root of this distribution.
//      By using this software in any fashion, you are agreeing to be bound by the
//      terms of this license.
//     
//      You must not remove this notice, or any other, from this software.
//------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Reflection;
using System.IO;
using System.Security.Cryptography;
using System.Diagnostics;

namespace WinProtectApp
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void calculateButton_Click(object sender, EventArgs e)
        {
            int value = int.Parse(textBox1.Text);
            int power = int.Parse(textBox2.Text);
            int result = 0;

            PasswordForm askPassword = new PasswordForm();
            if (askPassword.ShowDialog() == DialogResult.OK)
            {
                // Récupère le mote de passe
                string password = askPassword.Password;
                byte[] rawAsm;

                // Génération du mot de passe
                PasswordDeriveBytes pwdGen = new PasswordDeriveBytes(password, MD5CryptoServiceProvider.Create().ComputeHash(Encoding.UTF8.GetBytes(password)));
                byte[] key = pwdGen.GetBytes(16);
                byte[] vector = pwdGen.GetBytes(8);

                Debug.WriteLine("key:" +  Convert.ToBase64String(key)+ "; vector:"+ Convert.ToBase64String(vector));

                // Déchiffrement Triple-DES
                TripleDESCryptoServiceProvider provider = new TripleDESCryptoServiceProvider();
                provider.Key = key;
                provider.IV = vector;
                provider.Padding = PaddingMode.PKCS7;

                // Récupère l'assembly protégée embarquée
                Stream inStream = Assembly.GetExecutingAssembly().GetManifestResourceStream("WinProtectApp.ProtectedLib.Crypted.dll");
                // Crée le stream qui contiendra l'assembly déchiffrée
                using (MemoryStream outStream = new MemoryStream())
                {
                    try
                    {
                        // Crée le stream de déchiffrement
                        using (CryptoStream stream = new CryptoStream(inStream, provider.CreateDecryptor(), CryptoStreamMode.Read))
                        {
                            BinaryReader reader = new BinaryReader(stream);
                            int length = 256;
                            byte[] buffer = new byte[length];
                            // Lecture du stream d'entrée et écriture vers le stream de sortie en mémoire

                            while (reader.Read(buffer, 0, length) > 0)
                            {
                                outStream.Write(buffer, 0, length);
                            }
                            reader.Close();
                            stream.Flush();
                        }
                    }
                    catch (CryptographicException cex)
                    {
                        // Bad password
                        Debug.WriteLine(cex.Message);
                        return;
                    }
                    // Récupération du contenu du stream de sortie
                    rawAsm = outStream.ToArray();                    
                }
                // Utiliser les techniques de Reflection pour exécuter les méthodes de l'assembly protégée
                Assembly clearAsm = Assembly.Load(rawAsm);
                Type secretClassType = clearAsm.GetType("ProtectedLib.SecretClass");
                object instance = clearAsm.CreateInstance(secretClassType.FullName);
                MethodInfo method = secretClassType.GetMethod("Calculate");
                result = (int)method.Invoke(instance, new object[] { value, power });
            }
            resultLabel.Text = string.Format("{0}", result);
        }

        private void publiKeyShowButton_Click(object sender, EventArgs e)
        {
            AssemblyName currentAsmName = Assembly.GetExecutingAssembly().GetName(false);
            publicKeyBase64.Text = Convert.ToBase64String(currentAsmName.GetPublicKey());
        }
    }
}
