import java.io.InputStream;
import java.io.OutputStream;

import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class SPPConnection implements Runnable {

	public final static int CONNECTED = 1;

	public final static int DISCONNECTED = 0;

	public final static int RAW = 0;

	public final static int LINE = 1;

	private InputStream is = null;

	private SPPConnectionListener listener;

	private OutputStream os = null;

	private int status = DISCONNECTED;

	private String url;

	private int mode;

	private String error;

	private byte[] buffer;

	private int pointer = 0;

	private StreamConnection con = null;

	public SPPConnection(String u, int m) {
		mode = m;
		url = u;
		if (mode == LINE)
			buffer = new byte[4096];
	}

	public SPPConnection(String u) {
		this(u, LINE);
	}

	public boolean connect() {
		error = null;
		con = null;
		try {
			con = (StreamConnection) Connector.open(url);
			os = con.openOutputStream();
			is = con.openInputStream();
			new Thread(this).start();
		} catch (Exception e) {
			error = "Cnn Exct: [" + url + "] os " + os + " is " + is
					+ " msg = " + e;
			System.out.println(error);
			status = DISCONNECTED;
			return false;
		}
		status = CONNECTED;
		return true;
	}

	public void run() {
		int cr;
		try {
			while (status != DISCONNECTED) {
				byte[] b = new byte[1024];
				cr = is.read(b);
				if (cr > 0 && listener != null) {
					if (mode == RAW) {
						byte[] bo = new byte[cr];
						for (int i = 0; i < cr; i++)
							bo[i] = b[i];
						listener.received(bo);
					} else {
						for (int i = 0; i < b.length; i++) {
							if (b[i] >= ' ')
								buffer[pointer++] = b[i];
							if (b[i] == 10) {
								String s = new String(buffer, 0, pointer);
								pointer = 0;
								listener.printLine(s);
							}
						}
					}
				}
			}
		} catch (Exception ex) {
			status = DISCONNECTED;
			error = ex + "";
			listener.printLine(null);
			close();
		}
	}

	public void close() {
		try {
			os.close();
		} catch (Exception ex) {
		}
		os = null;
		try {
			is.close();
		} catch (Exception ex) {
		}
		is = null;
		try {
			con.close();
		} catch (Exception ex) {
		}

		if (listener != null) {
			if (pointer != 0) {
				String s = new String(buffer, 0, pointer);
				pointer = 0;
				listener.printLine(s);
			}
			listener.closed();
		}
	}

	public boolean send(byte[] b) {
		try {
			os.write(b);
			return true;
		} catch (Exception ex) {
			close();
		}
		return false;
	}

	public String getError() {
		return error;
	}

	public InputStream getIs() {
		return is;
	}

	public SPPConnectionListener getListener() {
		return listener;
	}

	public OutputStream getOs() {
		return os;
	}

	public int getStatus() {
		return status;
	}

	public String getUrl() {
		return url;
	}

	public void setIs(InputStream is) {
		this.is = is;
	}

	public void setListener(SPPConnectionListener listener) {
		this.listener = listener;
	}
}
