﻿using System;
using System.IO;
using System.Windows.Forms;
using Infragistics.Win.AppStyling;

namespace AppStylingSample
{
    public partial class FormMain : Form
    {
        public FormMain()
        {
            InitializeComponent();
        }

        private void FormMain_Load(object sender, EventArgs e)
        {
            FillStyleList();
        }

        private void FillStyleList()
        {
            cmbStyles.Items.Clear();
            cmbStyles.Items.Add(String.Empty, String.Empty);

            DirectoryInfo stylesFolder 
                = new DirectoryInfo(
                    Path.Combine(Application.StartupPath, "Styles"));

            FileInfo[] styleFiles = stylesFolder.GetFiles("*.isl");

            foreach (FileInfo styleFile in styleFiles)
            {
                cmbStyles.Items.Add(styleFile, styleFile.Name);
            }
        }

        private void cmbStyles_ValueChanged(object sender, EventArgs e)
        {
            if (cmbStyles.Value != null)
            {
                FileInfo styleFile = cmbStyles.Value as FileInfo;
                if (styleFile != null)
                {
                    StyleManager.Load(styleFile.FullName);
                }
            }
        }

        private void btnRegister_Click(object sender, EventArgs e)
        {
            MessageBox.Show(
                "Registration service unavailable.", "Programmez.com");
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
    }
}
