/*
 * Film_clsClassBehavior.java
 */

package videotheque.behavior;

import java.util.*;
import leon.app.behavior.*;
import leon.app.behaviorinterface.*;
import leon.control.*;
import leon.data.*;

/**
 * Generic interface for all behaviors that applies on action.
 * This interface represents the default behavior for consult, set, filter
 * and delete actions.
 * @see LySetBehaviorInterface
 * @see LyCreateBehaviorInterface
 * @see LyDeleteBehaviorInterface
 * @see LyFilterBehaviorInterface
 */
public class Film_clsClassBehavior extends LyClassBehavior
{
	/**
	 * Global control of values before creating or modifying an object.
	 * If needed, extra values may be added during this control.
	 * @param setController the current LySetController instance
	 * @param newValues Set of values to control
	 * @return <LI>STATUS_IGNORE if the value has not change</LI>
	 *         <LI>STATUS_KO if the value is not correct</LI>
	 *         <LI>STATUS_OK if the value is correct</LI>
	 * @see leon.app.behaviorinterface.LySetBehaviorInterface#controlNewValues
	 */
	public short controlNewValues(LySetController set, LyValueSet newValues)
	{
		// Rcupration de la valeur de lattribut film_sortie
		LyValue sortie = newValues.getFieldValue("film_sortie");

		if ((sortie != null) && (sortie.getValue() != null))
		{
			int    anneeFilm = ((Integer)sortie.getValue()).intValue(); // Anne du film
			int    annee = Calendar.getInstance().get(Calendar.YEAR); // Anne courante

			if (anneeFilm > annee) // Vrification de lanne de sortie
			{
					set.showError("L'anne saisie doit tre antrieure  l'anne courante !"); // Affichage de lerreur

					return STATUS_KO; // Erreur remonte au framework
			}
		}

		return super.controlNewValues(set, newValues); // Traitement gnrique
	}
}
