/*
 * Guitable_film_clsBehavior.java
 */

package videotheque.behavior;

import leon.app.behavior.*;
import leon.control.*;
import leon.data.*;

/**
 * This interface defines the methods to implement in order to modify
 * the default behavior of a table controller.
 * @see LyTableController
 */
public class Guitable_film_clsBehavior extends LyTableBehavior
{
	/**
	 * Gets row color for the given object.
	 * @param tableController Table controller that requires the row color.
	 * @param object Object for which a row color is required.
	 * @return Color name or the name of a color resource.
	 * @see leon.app.behaviorinterface.LyTableBehaviorInterface#getRowColor
	 */
	public String getRowColor(LySimpleTableController tableController, LyObject object)
	{
		// Rcupration de la valeur de lattribut film_sortie
		LyValue    sortie = object.getFieldValue("film_sortie");

		if ((sortie != null) && (sortie.getValue() != null))
		{
			int    anneeFilm = ((Integer)sortie.getValue()).intValue(); // Annee du film
			int    annee = java.util.Calendar.getInstance().get(java.util.Calendar.YEAR); // Annee courante

			if (anneeFilm == annee) // Un nouveau film est affich avec la couleur cyan
				return "Cyan";
		}

		return super.getRowColor(tableController, object); // Traitement gnrique
	}
}
