using System;
using Microsoft.Messenger;

namespace MessengerAddin
{
    public class MyAddin : IMessengerAddIn
    {
        private MessengerClient _messenger;

        public void Initialize(Microsoft.Messenger.MessengerClient messenger)
        {
            _messenger = messenger;
            _messenger.IncomingTextMessage += new System.EventHandler<IncomingTextMessageEventArgs>(_messenger_IncomingTextMessage);
        }
        void _messenger_IncomingTextMessage(object sender, IncomingTextMessageEventArgs e)
        {
            string msg = e.TextMessage.ToLower();
            if (msg.Contains("date"))
            {
                string HeureToWLM = DateTime.Now.ToString("HH:mm:ss");
                string DateToWLM = DateTime.Now.ToString("dd-MM-yyyy");

                _messenger.SendTextMessage((DateToWLM + " " + HeureToWLM), e.UserFrom);
            }
        }

    }
}