/*
 * Decompiled with CFR 0.152.
 */
package pkg;

import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import pkg.Assertion;
import pkg.AssertionFailedException;

public class ToolsStrings {
    public static final char dateSeparator = '/';
    public static final String SautDeLigne = "\r\n";

    public static String[] Split(String aString, char aSeparatorChar) {
        if (aString == null) {
            return null;
        }
        int len = aString.length();
        if (len == 0) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (aString.charAt(i) == aSeparatorChar) {
                if (match) {
                    list.addElement(aString.substring(start, i).trim());
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.addElement(aString.substring(start, i).trim());
        }
        Object[] arr = new String[list.size()];
        list.copyInto(arr);
        return arr;
    }

    public static String VectorToString(Vector aVector, String aSeparator) throws AssertionFailedException {
        Assertion.Assert(aVector != null, "VectorToString");
        StringBuffer result = new StringBuffer("");
        int i = 0;
        while (i < aVector.size()) {
            String aRecord = aVector.elementAt(i).toString();
            result.append(aRecord);
            if (i < aVector.size() - 1) {
                result.append(aSeparator);
            }
            ++i;
        }
        String res = result.toString();
        return res;
    }

    public static Vector StringToVector(String aString) {
        int j = 0;
        StringBuffer stringToRead = new StringBuffer("");
        Vector<StringBuffer> list = new Vector<StringBuffer>();
        int i = 0;
        while (i < aString.length()) {
            if (aString.charAt(i) != '\r') {
                if (aString.charAt(i) == '\n') {
                    if (stringToRead.length() > 0) {
                        list.addElement(stringToRead);
                    }
                    stringToRead = new StringBuffer("");
                    ++j;
                } else {
                    stringToRead.append(aString.charAt(i));
                }
            }
            ++i;
        }
        if (stringToRead.length() > 0) {
            list.addElement(stringToRead);
        }
        return list;
    }

    public static String DateToStr(Date aDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(aDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int date = calendar.get(5);
        return "" + date + '/' + month + '/' + year;
    }

    public static Date StrToDate(String aDate) throws AssertionFailedException {
        String[] dateTab = ToolsStrings.Split(aDate, '/');
        Assertion.Assert(dateTab.length == 3, "StrToDate 1 : \"" + aDate + "\"");
        Calendar calendar = Calendar.getInstance();
        int year = Integer.parseInt(dateTab[2]);
        int month = Integer.parseInt(dateTab[1]) - 1;
        int date = Integer.parseInt(dateTab[0]);
        Assertion.Assert(year >= 2000, "StrToDate 2 : \"" + aDate + "\"");
        Assertion.Assert(year <= 2099, "StrToDate 3 : \"" + aDate + "\"");
        Assertion.Assert(month < 12, "StrToDate 4 : \"" + aDate + "\"");
        Assertion.Assert(month >= 0, "StrToDate 5 : \"" + aDate + "\"");
        Assertion.Assert(date > 0, "StrToDate 6 : \"" + aDate + "\"");
        Assertion.Assert(date <= 31, "StrToDate 7 : \"" + aDate + "\"");
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, date);
        return calendar.getTime();
    }
}

