package pkg;

import java.util.Date;

public class DonneePlein {

    Date date;
    double litre;
    double km;
    int voiture;
    
    public DonneePlein (Date aDate, double aLitres, double aKm, int aVoiture) throws AssertionFailedException
    {
        Assertion.Assert(aKm>=0.01,"\""+aKm+"\" doit tre >=0.01");
        Assertion.Assert(aKm<=1600,"\""+aKm+"\" doit tre <=1600");
        Assertion.Assert(aLitres>=0,"\""+aLitres+"\" doit tre >=0");
        Assertion.Assert(aLitres<=100,"\""+aLitres+"\" doit tre <=100");
        Assertion.Assert(aDate!=null,"aDate!=null");
        date = aDate; 
        litre = aLitres; 
        km = aKm; 
        voiture = aVoiture;
    }

    public DonneePlein(String aDate, String aLitre, String aKm, String aVoiture) throws AssertionFailedException
    {
        date = ToolsStrings.StrToDate(aDate);
        litre = Double.parseDouble(aLitre); 
        km = Double.parseDouble(aKm); 
        voiture = Integer.parseInt(aVoiture);
    }

    public String toString()
    {
        
        String strDate = ToolsStrings.DateToStr(date);
        String strLitre = ""+litre; 
        String strKm = ""+km; 
        String strVoiture = ""+voiture;
        String result = strDate   +Donnees.FichierSeparateur+
                        strLitre  +Donnees.FichierSeparateur+
                        strKm     +Donnees.FichierSeparateur+
                        strVoiture;
        return result;
    }
}
