package pkg;

import java.util.Date;
import java.util.Vector;

import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class Donnees {
// Constantes
    static public final String FichierApplication ="NokiaEssence.txt";
    static public final char FichierSeparateur =';';
// Attributs
    private FileConnection mainFileConnection = null;
    public String[] voitures = null; // Liste des voitures pour l'application
    public Vector pleins = null; // Vecteur de Strings
    
    private String VoituresToString()
    {
        String result = "";
        int i;
        for (i=0;i<voitures.length;i++)
        {
            result = result + voitures[i];
            if (i<voitures.length-1) result = result + FichierSeparateur;
        }
        return result;
    }
    
    public void LoadFromFile() throws java.io.IOException,NokiaEssenceException,AssertionFailedException 
    {
        FileConnection fconn = GetFileConnection();
        String dataStr = ToolsFiles.ReadFromFile(fconn);
        pleins = ToolsStrings.StringToVector(dataStr);
        if (pleins==null || pleins.size()<=0)
        {
            throw new NokiaEssenceException("Les voitures ne sont pas dfinies dans le fichier");
        }
        String dataVoitures = pleins.elementAt(0).toString();
        voitures = ToolsStrings.Split(dataVoitures,FichierSeparateur);
        if (voitures==null || voitures.length<=0)
        {
            throw new NokiaEssenceException("Aucune voitures dfinie dans le fichier");
        }
        // On retire la premire ligne car elle contient la liste des voitures
        pleins.removeElementAt(0);
    }

    public void SaveToFile() throws java.io.IOException,NokiaEssenceException,AssertionFailedException
    {
        FileConnection fconn = GetFileConnection();
        String strVoitures = VoituresToString();
        String strPleins = ToolsStrings.VectorToString(pleins,ToolsStrings.SautDeLigne);
        String dataStr = strVoitures+ToolsStrings.SautDeLigne+strPleins;
        ToolsFiles.WriteToFileString(fconn,dataStr,false);
    }

    public String VoitureIntToLibelle(int aVoiture) throws AssertionFailedException
    {
        Assertion.Assert(aVoiture>=0,"\""+aVoiture+"\"<0");
        Assertion.Assert(aVoiture<VoitureCount(),"\""+aVoiture+"\"<\""+VoitureCount()+"\"");
        return voitures[aVoiture];
    }
    
    public int VoitureCount()
    {
        return voitures.length;
    }    

    public FileConnection GetFileConnection() throws java.io.IOException,NokiaEssenceException
    {
         if (mainFileConnection == null)
         {
                String url = ToolsFiles.GetFileName(FichierApplication);
                
                mainFileConnection = (FileConnection) Connector.open( url, Connector.READ_WRITE );
                boolean b = mainFileConnection.exists();
                if (!b)
                {
                    throw new NokiaEssenceException("Le fichier \""+FichierApplication+"\" n'existe pas. (Url ="+url+")");
                }
                return mainFileConnection;
         } else
         {
            return  mainFileConnection;
         }
    }
    
    public void Add(Date aDate,double aLitres,double aKm,int aVoiture) throws java.io.IOException,AssertionFailedException,NokiaEssenceException
    {
        Assertion.Assert(aVoiture>=0,"\""+aVoiture+"\"<0");
        Assertion.Assert(aVoiture<VoitureCount(),"\""+aVoiture+"\"<\""+VoitureCount()+"\"");

        DonneePlein donnePlein = new DonneePlein(aDate,aLitres,aKm,aVoiture);
        pleins.addElement(donnePlein.toString());
        SaveToFile();
    }

    public void DeleteAll() throws java.io.IOException,NokiaEssenceException,AssertionFailedException
    {
        pleins.removeAllElements();
        Assertion.Assert(pleins.size()==0,"pleins.size()==0");
        SaveToFile();
    }
    
    public void Delete(int aIndex)  throws java.io.IOException,NokiaEssenceException,AssertionFailedException
    {
         Assertion.Assert(aIndex>=0,"Delete : \""+aIndex+"\"<0");
         Assertion.Assert(aIndex<pleins.size(),"Delete : \""+aIndex+"\">=\""+pleins.size()+"\"");
         pleins.removeElementAt(aIndex);
         SaveToFile();
    }
}
