/* This file was created by Carbide.j */
package pkg;

//import java.io.InputStream;
import java.util.Date;
import javax.microedition.lcdui.*;

public class MainForm extends Form implements CommandListener
{
     static public final String TitreApplication ="NokiaEssence v0.57";
     static public final javax.microedition.lcdui.Command commandExit = new Command("Exit", Command.EXIT, 0);
     static public final javax.microedition.lcdui.Command commandOk = new Command("Ok", Command.OK, 1);
     static public final javax.microedition.lcdui.Command commandSauver = new Command("Sauver", Command.ITEM, 2);
     static public final javax.microedition.lcdui.Command commandVisualiser = new Command("Visualiser", Command.ITEM, 3);
     static public final javax.microedition.lcdui.Command commandDebug = new Command("Debug", Command.ITEM, 4);
     javax.microedition.lcdui.DateField dateField = new DateField("DateField", DateField.DATE);
     javax.microedition.lcdui.TextField textFieldKm = new TextField("TextField", "", 50, TextField.ANY);
     javax.microedition.lcdui.TextField textFieldLitres = new TextField("TextField", "", 50, TextField.ANY);
     javax.microedition.lcdui.ChoiceGroup choiceGroupVoiture = new ChoiceGroup("ChoiceGroup", ChoiceGroup.EXCLUSIVE);
     public NokiaEssenceMIDlet nokiaEssenceMIDlet = null;
     public Donnees donnees = new Donnees();
// Constructeurs     
     public MainForm(String p1)
     {
          super(p1);
     }

     public MainForm(NokiaEssenceMIDlet aNokiaEssenceMIDlet) throws Exception
     {
          this("");
          nokiaEssenceMIDlet = aNokiaEssenceMIDlet;
          ndsInit();
     }
// Init de la fiche
     void ndsInit() throws Exception
     {
          this.addCommand(commandExit);
          this.addCommand(commandOk);
          this.addCommand(commandSauver);
          this.addCommand(commandVisualiser);
          this.addCommand(commandDebug);
          this.setCommandListener(this);
          setTitle(TitreApplication);
          // Date
          // Litres 
          append(textFieldLitres);
          textFieldLitres.setConstraints(TextField.DECIMAL);
          textFieldLitres.setLabel("Litres");
          textFieldLitres.setMaxSize(6);
          // Km 
          append(textFieldKm);
          textFieldKm.setLabel("Km");
          textFieldKm.setMaxSize(6);
          textFieldKm.setConstraints(TextField.DECIMAL);
          // Init a la date d'aujourdhui
          append(dateField);
          dateField.setDate(new Date(0));
          dateField.setLabel("Date");
          Date CurrDate = new Date();
          dateField.setDate(CurrDate);
          // Lecture des donnes. Les voitures ncessitent d'avoir la liste
          donnees.LoadFromFile();
          // Voiture
          append(choiceGroupVoiture);
          int i;
          Assertion.Assert(donnees.VoitureCount()>0,"Pas de voitures dfinies");
          for (i=0;i<donnees.VoitureCount();i++)
          {
              choiceGroupVoiture.append(donnees.VoitureIntToLibelle(i), null);
          }
          choiceGroupVoiture.setSelectedIndex(0, true);
          choiceGroupVoiture.setLabel("Voiture");
     }
// Calcul des taux
     public double CalculTaux(double aLitres,double aKm) throws AssertionFailedException
     {
         Assertion.Assert(aKm!=0,"Division par 0 impossible");
         Assertion.Assert(aKm>=0.01,"\""+aKm+"\" doit tre >=0.01");
         Assertion.Assert(aKm<=1600,"\""+aKm+"\" doit tre <=1600");
         Assertion.Assert(aLitres>=0,"\""+aLitres+"\" doit tre >=0");
         Assertion.Assert(aLitres<=100,"\""+aLitres+"\" doit tre <=100");
         return aLitres * 100 / aKm;
     }

     public String CalculTauxIHM() throws AssertionFailedException
     {
          String Litres;
          String Km;
          Litres = textFieldLitres.getString();
          Km = textFieldKm.getString();
          return CalculTauxStr(Litres,Km);
     }
     
     public double CalculTaux(String aLitres,String aKm) throws AssertionFailedException
     {
          double Litres;
          double Km;
          Litres = Double.parseDouble(aLitres);
          Km = Double.parseDouble(aKm);
          return CalculTaux(Litres,Km);
     }

     public String CalculTauxStr(String aLitres,String aKm) throws AssertionFailedException
     {
         double taux = CalculTaux(aLitres,aKm);
         String resStr = Double.toString(taux);
         int size = Math.min(resStr.length(),5);
         resStr = resStr.substring(0,size);  // Pout limiter le nombre de chiffres aprs la virgule
         return resStr;
     }
// Verification que tous les champs soient bien remplis     
     public boolean Verify()
     {
          if ( textFieldKm.getString().length() == 0 || textFieldLitres.getString().length() == 0 )
          {
               nokiaEssenceMIDlet.ShowMessage("Attention", "Vous devez renseigner les champs.", AlertType.ERROR);
               return false;
          }
          double km = Double.parseDouble(textFieldKm.getString());
          if (( km <= 0.01 ) || ( km >= 1600 ))
          {
               nokiaEssenceMIDlet.ShowMessage("Attention", "Valeur incorrecte pour Km.", AlertType.ERROR);
               return false;
          }
          double litres = Double.parseDouble(textFieldLitres.getString());
          if (( litres <= 0 ) || ( litres >= 100 ))
          {
               nokiaEssenceMIDlet.ShowMessage("Attention", "Valeur incorrecte pour Litres.", AlertType.ERROR);
               return false;
          }   
          return true;
     }
// Operations courantes
     public void SupprimerRecord(int aRecordIndex) throws java.io.IOException,AssertionFailedException,NokiaEssenceException
     {
         Assertion.Assert(aRecordIndex>=0,"SupprimerRecord : \""+aRecordIndex+"\"<0");
         Assertion.Assert(aRecordIndex<donnees.pleins.size(),"SupprimerRecord : \""+aRecordIndex+"\">=\""+donnees.pleins.size()+"\"");
         donnees.Delete(aRecordIndex);
         ActionVisualiser(); // Pour rafraichir la liste
     }
     
     public void SupprimerTout() throws java.io.IOException,AssertionFailedException,NokiaEssenceException
     {
         donnees.DeleteAll();
         ActionVisualiser(); // Pour rafraichir la liste
     }
// Affichage...     
     public void ShowDetaille(String aDate,String aLitres,String aKm,String aVoiture) throws AssertionFailedException
     {
         String Msg;
         Msg =  aDate                    +ToolsStrings.SautDeLigne+
            aLitres.toString()   +" L"   +ToolsStrings.SautDeLigne+
            aKm.toString()       +" Km"  +ToolsStrings.SautDeLigne+
            CalculTauxStr(aLitres,aKm);
         nokiaEssenceMIDlet.ShowMessage(aVoiture,Msg,AlertType.INFO);
     }

     public void ShowDetaille(String aRecord) throws AssertionFailedException,NokiaEssenceException
     {
         String date,litres,km,voiture;
         String[] tab;
         tab=ToolsStrings.Split(aRecord,Donnees.FichierSeparateur);
         if (tab.length!=4) throw new NokiaEssenceException("Structure du fichier incorrecte : tab.length = \""+tab.length+"\"");
         date    = tab[0];
         litres  = tab[1];
         km      = tab[2];
         voiture = tab[3];
         // On transforme le N de voiture en libell
         int voitureInt = Integer.parseInt(voiture);
         Assertion.Assert(voitureInt>=0,"\""+voitureInt+"\"<0");
         Assertion.Assert(voitureInt<donnees.VoitureCount(),"\""+voitureInt+"\"<\""+donnees.VoitureCount()+"\"");
         voiture = donnees.voitures[voitureInt];
         ShowDetaille(date,litres,km,voiture);
     }
// Les actions     
     public void commandAction(Command aCommand, Displayable aDisplayable)
     {
         try
         {
              if ( aCommand == commandExit )       nokiaEssenceMIDlet.notifyDestroyed();
              if ( aCommand == commandOk )         ActionOk();
              if ( aCommand == commandSauver )     ActionSauver();
              if ( aCommand == commandVisualiser ) ActionVisualiser();
              if ( aCommand == commandDebug )      ActionDebug();
         }
         catch( Exception e ) 
         {
             nokiaEssenceMIDlet.ShowError(e);
         }          
     }
     
     public void ActionOk() throws AssertionFailedException
     {
          if ( Verify() )
          {
               String resStr = CalculTauxIHM(); 
               nokiaEssenceMIDlet.ShowMessage("Rsultat", resStr, AlertType.INFO);
          }
     }

     public void ActionSauver() throws java.io.IOException,AssertionFailedException,NokiaEssenceException
     {
        if  (!Verify()) return;
        String strKm,strLitres;
        Date date;
        date = dateField.getDate();
        strKm = textFieldKm.getString();
        strLitres = textFieldLitres.getString();
        double km = Double.parseDouble(strKm);
        double litres = Double.parseDouble(strLitres);
        int voiture = choiceGroupVoiture.getSelectedIndex();
        
        donnees.Add(date,litres,km,voiture);
        nokiaEssenceMIDlet.ShowMessage("Sauvegarde","Sauvegarde effectue",AlertType.INFO);
     }
     
     public void ActionVisualiser() throws java.io.IOException,AssertionFailedException
     {
        if (donnees.pleins.size()<=0)
        {
            nokiaEssenceMIDlet.ShowError("Vide", "Aucune donne  afficher");
            return;
        }
        String[] dataStrings = new String[donnees.pleins.size()];
        int i;
        for (i=0;i<donnees.pleins.size();i++)
         {
            dataStrings[i] = donnees.pleins.elementAt(i).toString(); 
         }

         VisuForm visuForm = new VisuForm(dataStrings,this);
         Display.getDisplay(nokiaEssenceMIDlet).setCurrent(visuForm);           
     }
      
     public void ActionDebug() throws AssertionFailedException
     {
         nokiaEssenceMIDlet.ShowMessage("","",AlertType.WARNING);
     }
     
}