package com.programmez.fred.pluginjython;

import java.io.IOException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class JythonDataLoader extends UniFileLoader {
    
    public static final String REQUIRED_MIME = "text/x-jython";
    
    private static final long serialVersionUID = 1L;
    
    public JythonDataLoader() {
        super("com.programmez.fred.pluginjython.JythonDataObject");
    }
    
    protected String defaultDisplayName() {
        return NbBundle.getMessage(JythonDataLoader.class, "LBL_Jython_loader_name");
    }
    
    protected void initialize() {
        super.initialize();
        getExtensions().addMimeType(REQUIRED_MIME);
    }
    
    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        return new JythonDataObject(primaryFile, this);
    }
    
    protected String actionsContext() {
        return "Loaders/" + REQUIRED_MIME + "/Actions";
    }
    
}
