package com.programmez.fred.pluginjython;

import java.io.IOException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public final class RunScriptJython extends CookieAction {
    
    protected void performAction(Node[] activatedNodes) {

        JythonDataObject d = (JythonDataObject) activatedNodes[0].getCookie(JythonDataObject.class);
	FileObject f = d.getPrimaryFile();
	String filename = FileUtil.getFileDisplayName(f);
        NotifyDescriptor nd = new NotifyDescriptor.Message("Vous tes sur le point de lancer: \n"+  filename);
        DialogDisplayer.getDefault().notify(nd);
        
        Runtime rt = Runtime.getRuntime();
        try {
            String cmd = "jython.bat" + " " + "\""+filename+"\"";
            System.out.println(cmd);
            rt.exec(cmd);
        } catch (IOException ex) {
            ex.printStackTrace();
        }

    }
    
    protected int mode() {
        return CookieAction.MODE_EXACTLY_ONE;
    }
    
    public String getName() {
        return NbBundle.getMessage(RunScriptJython.class, "CTL_RunScriptJyton");
    }
    
    protected Class[] cookieClasses() {
        return new Class[] {
            EditorCookie.class
        };
    }
    
    protected void initialize() {
        super.initialize();
        // see org.openide.util.actions.SystemAction.iconResource() javadoc for more details
        putValue("noIconInMenu", Boolean.TRUE);
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected boolean asynchronous() {
        return false;
    }
    
}

