

package com.programmez.fred.pluginjython1;


import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;

 
public class JythonModuleOption extends SystemOption {
 
    private static JythonModuleOption instance = null;
    
    public static final String PROPERTY_JYTHONHOME = "Jython Home";
    
    public static JythonModuleOption getDefault() {
        return (JythonModuleOption) findObject(JythonModuleOption.class, true);
    }
 
    protected void initialize() {
        setJythonHome("c:/jython-2.1");
        super.initialize();
    }
 
    public String displayName() {
        return "Jython Settings";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
 
    public String getJythonHome() {
        return (String) getProperty(PROPERTY_JYTHONHOME);
    }
 
    public void setJythonHome(String newhome) {
        putProperty(PROPERTY_JYTHONHOME, newhome, true);
    }
}
