package com.programmez.fred.pluginjython1;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.openide.cookies.EditorCookie;
import org.openide.execution.ExecutionEngine;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;



class StdHandler extends Thread {
    InputStream is;
    OutputWriter ow;
    
    StdHandler(InputStream is, OutputWriter ow) {
        this.is = is;
        this.ow = ow;
    }
    
    public void run() {
        try {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String ligne=null;
            while ( (ligne = br.readLine()) != null)
                ow.println(ligne);
        } catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

class ScriptRunnable implements Runnable {
    private InputOutput io;
    private String cmd;
    
    ScriptRunnable(String cmd, InputOutput io) {
        this.cmd = cmd;
        this.io = io;
    }
    
    public void run() {
        try {
            if (io != null) {
                OutputWriter owo = io.getOut();
                OutputWriter owe = io.getErr();
                owo.println("lancement du script:");
                owo.println(cmd);
                
                
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(cmd);
                
                StdHandler stdout = new StdHandler(proc.getInputStream(), owo);
                StdHandler stderr = new StdHandler(proc.getErrorStream(), owe);
                
                stdout.start();
                stderr.start();
                
                int exitVal = proc.waitFor();
            }
            
        } catch (Throwable t) {
            t.printStackTrace();
        }
    }
}



public final class RunScriptJython extends CookieAction {
    
    protected void performAction(Node[] activatedNodes) {
        // Obtenir la localisation de Jython
        // dans les options de Netbeans
        String jython_home =
                JythonModuleOption.getDefault().getJythonHome();
        // Un travail soign poserait un sparateur
        // en fonction de l'os hte.
        String jython_cmd = jython_home + "/" + "jython.bat";
        File f = new File(jython_cmd);
        // Jython absent physiquement ?
        if(f==null || !f.exists())
            return;
        
        // rcuprer le nom du fichier script
        //  lancer
        JythonDataObject d = (JythonDataObject) activatedNodes[0].getCookie(JythonDataObject.class);
        FileObject fo = d.getPrimaryFile();
        String filename = FileUtil.getFileDisplayName(fo);
        // commande totale
        String cmd = jython_cmd + " " + "\""+filename+"\"";
        
        // Accder au panneau de sortie dans le "Mode" Output de Netbeans
        InputOutput io = IOProvider.getDefault().getIO(d.getName(), false);
        try {
            io.getOut().reset();
        } catch (IOException exc ) {
        }
        ScriptRunnable sr = new ScriptRunnable(cmd, io);
        // C'est parti mon kiki! :-)
        ExecutionEngine.getDefault().execute(d.getName(), sr, io);
    }
    
    protected int mode() {
        return CookieAction.MODE_EXACTLY_ONE;
    }
    
    public String getName() {
        return NbBundle.getMessage(RunScriptJython.class, "CTL_runScriptJython");
    }
    
    protected Class[] cookieClasses() {
        return new Class[] {
            EditorCookie.class
        };
    }
    
    protected void initialize() {
        super.initialize();
        // see org.openide.util.actions.SystemAction.iconResource() javadoc for more details
        putValue("noIconInMenu", Boolean.TRUE);
    }
    
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    protected boolean asynchronous() {
        return false;
    }
    
}

