﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Wordprocessing;

namespace GenerationWord
{
    class Program
    {
        static void Main(string[] args)
        {
            using (WordprocessingDocument wordDoc =
                WordprocessingDocument.Create("Demo.docx",
                DocumentFormat.OpenXml.WordprocessingDocumentType.Document))
            {
                // Création d'une nouvelle partie de contenu 
                MainDocumentPart mainPart = wordDoc.AddMainDocumentPart();
                // Création d'un nouveau paragraphe 
                Document mainDoc = new Document(
                    new Body(
                    new Paragraph(
                        new ParagraphProperties(
                            new ParagraphStyleId() { Val = "Title" }),
                        new Run(
                            new RunProperties(
                                new Italic()),
                            new Text("Bienvenue au SDK Open XML V2 !")
                        ))));
                // Enregistrement de la partie 
                mainDoc.Save(mainPart);
                // Création d'une nouvelle partie de style 
                StyleDefinitionsPart stylePart = mainPart.AddNewPart<StyleDefinitionsPart>();
                Styles styles = new Styles(
                        new Style(
                        new Name() { Val = "Title" },
                        new BasedOn() { Val = "Normal" },
                        new NextParagraphStyle() { Val = "Normal" },
                        new LinkedStyle() { Val = "TitleChar" },
                        new UIPriority() { Val = 10 },
                        new PrimaryStyle(),
                        new Rsid() { Val = "002C2DBE" },
                        new ParagraphProperties(
                            new ParagraphBorders(
                                new BottomBorder() { Val = BorderValues.Single, Color = "auto", Size = (UInt64)4UL, Space = (UInt64)1UL }),
                            new SpacingBetweenLines() { Line = 240, LineRule = LineSpacingRuleValues.Auto },
                            new ContextualSpacing()),
                        new RunProperties(
                            new RunFonts() { AsciiTheme = ThemeFontValues.MajorHighAnsi, HighAnsiTheme = ThemeFontValues.MajorHighAnsi, EastAsiaTheme = ThemeFontValues.MajorEastAsia, ComplexScriptTheme = ThemeFontValues.MajorBidi },
                            new Spacing() { Val = 5 },
                            new FontSize() { Val = (UInt64)52UL },
                            new FontSizeComplexScript() { Val = (UInt64)52UL })
                    ) { Type = StyleValues.Paragraph, StyleId = "Title" });
                // Enregistrement des styles 
                styles.Save(stylePart);
            }
        }
    }
}
