﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Spreadsheet;

namespace ConsommerFeuilleExcel
{
    class Program
    {
        static WorksheetPart ObtenirPartieFeuille(WorkbookPart classeur, string nomFeuille)
        {
            try
            {
                Sheet feuille = classeur.Workbook.Descendants<Sheet>()
                    .Where(s => nomFeuille.Equals(s.Name)).First();
                return (WorksheetPart)classeur.GetPartById(feuille.Id);
            }
            catch (Exception)
            {
                return null;
            }
        }

        static Cell ObtenirCellule(WorksheetPart feuille, int indexLigne, int indexColonne)
        {
            try
            {
                Row row = feuille.Worksheet.Descendants<Row>()
                    .Where(r => indexLigne == r.RowIndex).First();
                return (Cell)row.ChildElements.ElementAt(indexColonne);
            }
            catch (Exception)
            {
                return null;
            }
        }

        static string ObtenirValeurCellule(Cell cellule, SharedStringTablePart sharedStringTablePart)
        {
            if (cellule.ChildElements.Count == 0)
                return null;

            string value = cellule.CellValue.InnerText;
            if ((cellule.DataType != null) && (cellule.DataType == CellValues.SharedString))
                value = sharedStringTablePart.SharedStringTable.ChildElements[Int32.Parse(value)].InnerText;
            return value;
        }

        static void Main(string[] args)
        {
            using (SpreadsheetDocument excelDoc = SpreadsheetDocument.Open("Sample.xlsx", false))
            {
                WorksheetPart feuille1 = ObtenirPartieFeuille(excelDoc.WorkbookPart, "Sheet1");

                Cell cA1 = ObtenirCellule(feuille1, 1, 0); // Ligne 1, première colonne (base 0)
                Cell cA2 = ObtenirCellule(feuille1, 2, 0); // Ligne 2, première colonne (base 0)
                Console.WriteLine("{0} {1}",
                    ObtenirValeurCellule(cA1, excelDoc.WorkbookPart.SharedStringTablePart),
                    ObtenirValeurCellule(cA2, excelDoc.WorkbookPart.SharedStringTablePart));
            }
        }
    }
}
