
#include "pconfigdialog.h"
#include <QDir>
#include <QFileDialog>
#include <QSettings>

PConfigDialog::PConfigDialog( QWidget *parent ) : QDialog(parent){
    setupUi(this);
    readSettings();
}

void PConfigDialog::setNoteList(QActionGroup *group){
    actionsGroup = group;
    QAction *ita;
    foreach (ita, actionsGroup->actions()){
	noteList->addItem(ita->text());
	QListWidgetItem *item = noteList->item( noteList->count()-1 );
	item->setToolTip(ita->toolTip());
    }
}

void PConfigDialog::on_removeNoteButton_clicked(){
    QListWidgetItem *item = noteList->currentItem();
    if(item){
	QAction *ita;
	foreach (ita, actionsGroup->actions()){
	    if( ita->text() == item->text() && ita->toolTip() == item->toolTip() ){
		emit(noteRemoved(ita));
		noteList->takeItem( noteList->row(item) );
		break;
	    }
	}
    }
}

void PConfigDialog::on_saveAsButton_clicked(){
    QString path = QDir::currentPath() ;
    if(!saveAsPath->text().isEmpty())
	path = saveAsPath->text();
    path = QFileDialog::getSaveFileName(this,tr("Quick Desktop Notes"), path , tr("RSS Files (*.rss)") );
    if(!path.isEmpty())
	saveAsPath->setText(path);
}

void PConfigDialog::on_openIconButton_clicked(){
    QString iconPath = QFileDialog::getOpenFileName(this,tr("Quick Desktop Notes"), QDir::currentPath() , tr("Images (*.png *.xpm *.jpg *.svg)") );
    if(!iconPath.isEmpty()){
	iconSelector->insertItem(0, QIcon(iconPath),iconPath );
	iconSelector->setCurrentIndex(0);
    }
}

void PConfigDialog::accept(){
    writeSettings();
    emit(settingsUpdated());
    QDialog::accept();
}

void PConfigDialog::writeSettings()
{
     QSettings settings("Programmez", "QuickDesktopNotes");
     settings.setValue("notesFileName",saveAsPath->text());
     settings.setValue("iconFileName",iconSelector->itemText((iconSelector->currentIndex())) );
}

void PConfigDialog::readSettings()
{
    QSettings settings("Programmez", "QuickDesktopNotes");
    saveAsPath->setText( settings.value("notesFileName","desktop_notes.rss").toString() );
    QString iconPath = settings.value("iconFileName",":/images/burn.png").toString();
    if(!iconPath.startsWith(":/")){
	iconSelector->insertItem(0, QIcon(iconPath),iconPath );
	iconSelector->setCurrentIndex(0);
    }
    else{
	iconSelector->setCurrentIndex( iconSelector->findText(iconPath) );
    }
}

