#ifndef PTRAY_H
#define PTRAY_H

#include <QSystemTrayIcon>
#include "pnoteeditor.h"

class QAction;
class QMenu;
class QString;

class PTray : PNoteEditor
{
    Q_OBJECT
    
    public:
	PTray();
	void setVisible(bool visible);
    
    protected:
	void closeEvent(QCloseEvent *event);
    
    private slots:
	void iconActivated(QSystemTrayIcon::ActivationReason reason);
	void showMessage();
	void messageClicked();
	void newNote();
	void editNote();
	void on_noteTitleChanged(const QString& str="");
	void on_noteTextChanged(const QString& str="");
	void showConfigDialog();
	void removeActionFromHistory(QAction *);
	void on_settingsUpdated();
	void quitTray();
	void loadRssFile(const QString&);
    
    private:
	void createActions();
	void createTrayIcon();
	void addNoteToHistory(const QString &title="", const QString &body="");
	void writeSettings();
	void writeNotes();
	void readSettings();
	QAction *quitAction;
	QAction *minimizeAction;
	QAction *maximizeAction;
	QAction *restoreAction;
	QAction *newNoteAction;
	QAction *currentNoteAction;
	QAction *configAction;
	QActionGroup *history;
	QSystemTrayIcon *trayIcon;
	QMenu *trayIconMenu;
	bool warnOnClose;
	QString notesFileName ;
	QString iconFileName ;
};

#endif 
