#include "pxmlhandler.h"
#include <QMessageBox>

PXmlHandler::PXmlHandler( QList<QAction *> *newList){
	actionList = newList;
	currentText = "";
	haveItem = false;
}

bool PXmlHandler::startElement( const QString &namespaceURI, const QString &localName, const QString &qName, const QXmlAttributes &attributes ){
	if( qName == "item" ){
		currentAction = new QAction( QString("none"),0 );
		haveItem=true;
	}
	else
	    if(qName == "title" || qName == "description")
		currentText = "";
	return true;
}

bool PXmlHandler::endElement( const QString &namespaceURI, const QString &localName, const QString &qName )
{
    if(haveItem){
	if(qName == "title")
	    currentAction->setText(currentText);
	else
	    if(qName == "description")
		currentAction->setToolTip(currentText);
	    else
		if(qName == "item"){
		    actionList->append(currentAction);
		    haveItem=false;
		}
    }
    return true;
}

bool PXmlHandler::characters(const QString &str){
	currentText += str ;
	return true;
}

bool PXmlHandler::fatalError(const QXmlParseException &exception){
	QMessageBox::warning(0,QObject::tr("QuickDesktopNotes XML/RSS parser"),
		QObject::tr("parse error at line %1, column %2:\n%3")
		.arg( exception.lineNumber() )
		.arg( exception.columnNumber() )
		.arg( exception.message() )
		
	);
	return false;
}
