using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;

namespace XnaPanic
{
    /// <summary>
    /// Game state
    /// </summary>
    public enum GameState { Menu, Play, Exit };

    /// <summary>
    /// Sounds
    /// </summary>
    public enum Sound { Dig, Exit, Fall, Falling, Fill, Step };

    /// <summary>
    /// Base class for all game screens
    /// </summary>
    public interface IGameScreen
    {
        /// <summary>
        /// Load graphic ressources
        /// </summary>
        /// <param name="content">ContentManager created by game class</param>
        void LoadGraphicsContent(ContentManager content, int width, int height);

        GameState Update(GamePadState gamepad, KeyboardState keyboard, GameTime gameTime);

        void Draw(SpriteBatch spriteBatch);
    }



    public interface IScoreService
    {
        int Best { get; }

        void GameScore(int value);
    }

    public interface INumberTracerService
    {
        int Width { get; }
        void Draw(SpriteBatch sb, int number, int left, int top, int digitCount);
    }

    public interface ISoundService
    {
        Cue PlaySound(Sound sound);
    }
}
