using System;
using System.Collections.Generic;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Storage;

namespace XnaPanic
{
    class MenuScreen : IGameScreen
    {
        private Game _game;
        private MultiTextureSprite _sprite;
        private IScoreService _scoreService;
        private INumberTracerService _numberTracerService;

        public MenuScreen(Game game)
        {
            _game = game;
            _scoreService = (IScoreService)game.Services.GetService(typeof(IScoreService));
            _numberTracerService = (NumberTracer)game.Services.GetService(typeof(INumberTracerService));
        }

        public void LoadGraphicsContent(ContentManager content, int width, int height)
        {
            _sprite = new MultiTextureSprite(SpriteHorizontalAlignment.Left, SpriteVerticalAlignment.Top, content, @"Sprites\Game", "MenuScreen");
            //_sprite.X = (width - _sprite.Width) / 2;
            //_sprite.Y = (height - _sprite.Height) / 2;
        }

        public GameState Update(GamePadState gamepad, KeyboardState keyboard, GameTime gameTime)
        {
            if ((gamepad.Buttons.Back == ButtonState.Pressed) || keyboard.IsKeyDown(Keys.Escape))
            {
                return GameState.Exit;
            }
            else if ((gamepad.Buttons.Start == ButtonState.Pressed) || keyboard.IsKeyDown(Keys.G))
            {
                return GameState.Play;
            }
            else
            {
                return GameState.Menu;
            }
        }

        public void Draw(SpriteBatch spriteBatch)
        {
            _sprite.Draw(spriteBatch);
            _numberTracerService.Draw(spriteBatch, _scoreService.Best, 648 + _sprite.X, 158 + _sprite.Y, 5);
        }
    }
}
