
#include <libpq-fe.h>

#include <iostream>

using namespace std;

// Spcifique Visual Studio
#pragma comment(lib, "libpq.lib")

const char* connexion_string = "user=fred password=**** host=localhost dbname=Formulix"; 
const char* query = "DECLARE moncurseur CURSOR FOR SELECT * FROM Pilotes ORDER BY Nom";
const char* fetch = "FETCH ALL IN moncurseur";
const char* fetch3 = "FETCH 3 IN moncurseur";
const char* fetch1back = "FETCH BACKWARD 1 IN moncurseur";

PGconn* connexion;
PGresult* result;

void InitDb()
{
	connexion = PQconnectdb(connexion_string);

	if(connexion == NULL)
	{
		cout << "L'objet connexion n'a pas pu etre cree" << endl;
		exit(1);
	}
	if (PQstatus(connexion) != CONNECTION_OK)
	{
		cout << "La connexion a la base n'a pu etre etablie" << endl;
		PQfinish(connexion);
		exit(1);
	}
	cout << "connexion etablie" << endl;
}

void EndDb(int code)
{
	PQfinish(connexion);
	cout << "Connexion fermee" << endl;
	exit(code);
}

void CheckResult(ExecStatusType stat)
{
	if(result == NULL)
		EndDb(1);
	if(PQresultStatus(result) != stat)
	{
		cout << "la requete n'a pas donne le resultat prevu" << endl;
		cout << "on arrete tout" << endl;
		PQclear(result);
		EndDb(1);
	}
}

int main(int argc, char* argv[])
{
	int lig, col;

	InitDb();
	
	//-----------------------------------------
	// PREMIERE demo curseur
	//-----------------------------------------
	// Dbuter la transaction
	result = PQexec(connexion, "BEGIN");
	CheckResult(PGRES_COMMAND_OK);
	// IMPORTANT ci-dessous
	PQclear(result);

	result = PQexec(connexion, query);
	CheckResult(PGRES_COMMAND_OK);
	PQclear(result);

	result = PQexec(connexion, fetch);
	CheckResult(PGRES_TUPLES_OK);
	lig = PQntuples(result);
	col = PQnfields(result);
	cout << query << endl;
	cout << "Le resultat comporte " << lig << " lignes sur " << col << " colonnes" << endl;
	// sortie des noms de colonnes
	cout << endl;
	for(int i=0; i<col; i++)
		cout << PQfname(result, i) << "\t";
	cout << endl << endl;
	
	// sortie du rsultat proprement dit
	for(int i=0; i<lig; i++)
	{
		for(int j=0; j<col; j++)
		{
			cout << PQgetvalue(result, i,j) << "\t";
		}
		cout << endl;
	}
	cout << endl << endl;
	PQclear(result);
	result = PQexec(connexion, "CLOSE moncurseur");
	PQclear(result);
	
	// Terminer la transaction
	result = PQexec(connexion, "END");
	PQclear(result);

	//----------------------------------------------------------------
	//-----------------------------------------
	// DEUXIEME demo curseur
	//-----------------------------------------
	result = PQexec(connexion, "BEGIN");
	CheckResult(PGRES_COMMAND_OK);
	// IMPORTANT ci-dessous
	PQclear(result);

	result = PQexec(connexion, query);
	CheckResult(PGRES_COMMAND_OK);
	PQclear(result);

	result = PQexec(connexion, fetch3);
	CheckResult(PGRES_TUPLES_OK);
	lig = PQntuples(result);
	col = PQnfields(result);
	cout << fetch3 << endl;
	cout << "Le resultat comporte " << lig << " lignes sur " << col << " colonnes" << endl;
	
	// sortie des noms de colonnes
	cout << endl;
	for(int i=0; i<col; i++)
		cout << PQfname(result, i) << "\t";
	cout << endl << endl;
	
	// sortie du rsultat proprement dit
	for(int i=0; i<lig; i++)
	{
		for(int j=0; j<col; j++)
		{
			cout << PQgetvalue(result, i,j) << "\t";
		}
		cout << endl;
	}
	cout << endl << endl;
	PQclear(result);

	// retour en arriere du curseur
	result = PQexec(connexion, fetch1back);
	CheckResult(PGRES_TUPLES_OK);
	cout << fetch1back << endl;
	cout << "le curseur est revenu en arriere:" << endl << endl;
	cout << PQgetvalue(result, 0, 0) << "\t";
	cout << PQgetvalue(result, 0, 1) << "\t";
	cout << PQgetvalue(result, 0, 2) << "\t";
	cout << PQgetvalue(result, 0, 3) << "\t";
	cout << endl << endl;
	result = PQexec(connexion, "CLOSE moncurseur");
	PQclear(result);
	
	// Terminer la transaction
	result = PQexec(connexion, "END");
	PQclear(result);
	EndDb(0);
}

