
#include <libpq-fe.h>

#include <iostream>
#include <cstdlib>

using namespace std;

// Spcifique Visual Studio
#pragma comment(lib, "libpq.lib")

const char* connexion_string = "user=fred password=**** host=localhost dbname=Programmez!"; 
const char* query = "SELECT * FROM Issues";
const char* dropquery = "DROP TABLE Issues";

PGconn* connexion;
PGresult* result;

void InitDb()
{
	connexion = PQconnectdb(connexion_string);

	if(connexion == NULL)
	{
		cout << "L'objet connexion n'a pas pu etre cree" << endl;
		exit(1);
	}
	if (PQstatus(connexion) != CONNECTION_OK)
	{
		cout << "La connexion a la base n'a pu etre etablie" << endl;
		PQfinish(connexion);
		exit(1);
	}
	cout << "connexion etablie" << endl;
}

void EndDb(int code)
{
	PQfinish(connexion);
	cout << "Connexion fermee" << endl;
	exit(code);
}

void CheckResult(ExecStatusType stat)
{
	if(result == NULL)
		EndDb(1);
	if(PQresultStatus(result) != stat)
	{
		cout << "la requete n'a pas donne le resultat prevu" << endl;
		cout << "on arrete tout" << endl;
		PQclear(result);
		EndDb(1);
	}
}

int main(int argc, char* argv[])
{
	#define NB_BLOB 4   
	Oid oids[NB_BLOB];

	InitDb();
	result = PQexec(connexion, query);
	CheckResult(PGRES_TUPLES_OK);
	for(int i=0;i<NB_BLOB; i++)
		oids[i] =(Oid)atoi(PQgetvalue(result, i, 1));
	PQclear(result);

	// Effacement des BLOBs 
	result = PQexec(connexion, "BEGIN");
	CheckResult(PGRES_COMMAND_OK);
	PQclear(result);
	for(int i=0; i<NB_BLOB; i++)
	{
		int flag = lo_unlink(connexion, oids[i]);
		if(flag == -1)
			cout << "Un blob n'a pas ete efface correctement" << endl;
	}
	result = PQexec(connexion, "END");
	PQclear(result);

	// Effacement de la table
	result = PQexec(connexion, dropquery);
	CheckResult(PGRES_COMMAND_OK);
	PQclear(result);
	EndDb(0);
}

