
#include <libpq-fe.h>
#include <libpq/libpq-fs.h>

#include <iostream>
#include <fstream>
#include <cstdlib>

using namespace std;

// Spcifique Visual Studio
#pragma comment(lib, "libpq.lib")

const char* connexion_string = "user=fred password=**** host=localhost dbname=Programmez!"; 
const char* query = "SELECT * FROM Issues WHERE id=85";
const char* target1 = "c:/temp/image1.jpg";
const char* target2 = "c:/temp/image2.jpg";


PGconn* connexion;
PGresult* result;

void InitDb()
{
	connexion = PQconnectdb(connexion_string);

	if(connexion == NULL)
	{
		cout << "L'objet connexion n'a pas pu etre cree" << endl;
		exit(1);
	}
	if (PQstatus(connexion) != CONNECTION_OK)
	{
		cout << "La connexion a la base n'a pu etre etablie" << endl;
		PQfinish(connexion);
		exit(1);
	}
	cout << "connexion etablie" << endl;
}

void EndDb(int code)
{
	PQfinish(connexion);
	cout << "Connexion fermee" << endl;
	exit(code);
}

void CheckResult(ExecStatusType stat)
{
	if(result == NULL)
		EndDb(1);
	if(PQresultStatus(result) != stat)
	{
		cout << "la requete n'a pas donne le resultat prevu" << endl;
		cout << "on arrete tout" << endl;
		PQclear(result);
		EndDb(1);
	}
}

int main(int argc, char* argv[])
{
	Oid monoid;
	int flag;

	InitDb();
	result = PQexec(connexion, query);
	CheckResult(PGRES_TUPLES_OK);
	monoid = (Oid)atoi(PQgetvalue(result, 0, 1));
	PQclear(result);

	// Importation d'un BLOB en une opration
	result = PQexec(connexion, "BEGIN");
	CheckResult(PGRES_COMMAND_OK);
	PQclear(result);
	flag = lo_export(connexion, monoid, target1);
	if(flag == 1)
		cout << "Importation du BLOB reussie" << endl;
	else
		cout << "Echec de l'importation du BLOB" << endl;
	result = PQexec(connexion, "END");
	PQclear(result);

	// importation d'un BLOB comme une copie de fichier

	int fd; // descripteur de fichier PostreSQL
	int lu;
	#define BUFSIZE 1000 
	char buffer[BUFSIZE];

	result = PQexec(connexion, "BEGIN");
	CheckResult(PGRES_COMMAND_OK);
	PQclear(result);
	fd = lo_open(connexion, monoid, INV_READ);
	
	fstream fs = fstream(target2, ios::out|ios::binary);
	while(true)
	{
		lu = lo_read(connexion, fd, buffer, BUFSIZE);
		if(lu <= 0)
		{
			cout << "Copie du BLOB terminee" << endl;
			break;
		}
		fs.write(buffer, lu);
	}
	fs.flush();
	fs.close();

	lo_close(connexion, fd);
	result = PQexec(connexion, "END");
	CheckResult(PGRES_COMMAND_OK);
	PQclear(result);
	
	EndDb(0);
}

