#include <libpq-fe.h>

#include <iostream>

using namespace std;

// Spcifique Visual Studio
#pragma comment(lib, "libpq.lib")

const char* connexion_string = "user=fred password=**** host=localhost dbname=Formulix"; 
const char* query = "SELECT * from Pilotes"; 

PGconn* connexion;
PGresult* result;

void InitDb()
{
	connexion = PQconnectdb(connexion_string);

	if(connexion == NULL)
	{
		cout << "L'objet connexion n'a pas pu etre cree" << endl;
		exit(1);
	}
	if (PQstatus(connexion) != CONNECTION_OK)
	{
		cout << "La connexion a la base n'a pu etre etablie" << endl;
		PQfinish(connexion);
		exit(1);
	}
	cout << "connexion etablie" << endl;
}

void EndDb(int code)
{
	PQfinish(connexion);
	cout << "Connexion fermee" << endl;
	exit(code);
}

void CheckResult(ExecStatusType stat)
{
	if(result == NULL)
		EndDb(1);
	if(PQresultStatus(result) != stat)
	{
		cout << "la requete n'a pas donne le resultat prevu" << endl;
		cerr << PQerrorMessage(connexion) << endl;
		cout << "on arrete tout" << endl;
		PQclear(result);
		EndDb(1);
	}
}

int main(int argc, char* argv[])
{
	int lig, col;

	InitDb();
	
	result = PQexec(connexion, query);
	CheckResult(PGRES_TUPLES_OK);
	lig = PQntuples(result);
	col = PQnfields(result);
	cout << query << endl;
	cout << "Le resultat comporte " << lig << " lignes sur " << col << " colonnes" << endl;
	// sortie des noms de colonnes
	cout << endl;
	for(int i=0; i<col; i++)
		cout << PQfname(result, i) << "\t";
	cout << endl << endl;
	
	// sortie du rsultat proprement dit
	for(int i=0; i<lig; i++)
	{
		for(int j=0; j<col; j++)
		{
			cout << PQgetvalue(result, i,j) << "\t";
		}
		cout << endl;
	}
	cout << endl << endl;
	PQclear(result);

	EndDb(0);
}

