// DemoGetaddrinfo.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winsock2.h>
#include <ws2tcpip.h>


#include <iostream>

using namespace std;

int main(int argc, char* argv[])
{
	WSADATA wsadata;
	SOCKET sock;

	if(::WSAStartup(MAKEWORD(2, 2), &wsadata))
	{
		cerr << "Impossible d'initialiser la Winsock" << endl;
		return EXIT_FAILURE;
	}
	cout << "Winsock initialisee" << endl;

	sock = socket(PF_INET6, SOCK_STREAM, 0);
	if(sock != INVALID_SOCKET)
		cout << "Socket cree" << endl;
	else
	{
		cerr << "Erreur a la creation du socket" << endl;
		::WSACleanup();
		return EXIT_FAILURE;
	}

	struct sockaddr_in6* addr6 = 0; 
	struct addrinfo hints;
	memset(&hints, 0, sizeof(addrinfo));
	hints.ai_family = PF_INET6;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_protocol = IPPROTO_IPV6;
	//const char* host = "debian-fr.org";
	const char* host = "2001:41d0:1:ed34::3";

	struct addrinfo*  addrinfo = 0;
	int res = ::getaddrinfo(host, 0, &hints, &addrinfo);
	if(res)
	{
		if(res == WSAHOST_NOT_FOUND)
			cerr << "Pas de resolution de noms..." << endl;
		else
			cerr << "Erreur a l'appel getaddinfo" << endl;
		::WSACleanup();
		return EXIT_FAILURE;
	}
	else
	{
		addr6 = (sockaddr_in6*)addrinfo->ai_addr;
		addr6->sin6_scope_id = 0;
		addr6->sin6_port = ::htons(80); // port 80 HTTP
	}

	// se connecter
	if(::connect(sock, (sockaddr*)addr6, sizeof(sockaddr_in6)))
	{
		cerr << "Impossible de connecter le socket" << endl;
		::closesocket(sock);
		::WSACleanup();
		return EXIT_FAILURE;
	}
	else
	{
		cout << "Socket connecte" << endl;
		freeaddrinfo(addrinfo);
	}
	
	// crire dans le socket
	const char* commande = "GET / HTTP/1.0\r\n\r\n";
	if(::send(sock, commande, strlen(commande), 0) == SOCKET_ERROR)
	{
		cerr << "Erreur lors de l'criture dans le socket" << endl;
		::closesocket(sock);
		::WSACleanup();
		return EXIT_FAILURE;
	}
	else
		cout << "Commande envoyee" << endl;

	// recevoir les donnes du serveur
	const int bufsize = 1;
	char buffer = 0;
	
	//memset(&buffer, 0, bufsize);
	int result = 0;
	cout << "Donnees lues:" << endl << endl;
	do
	{
		result = ::recv(sock, &buffer, bufsize, 0);
		if(result > 0)
			cout << buffer; 
	} while(result > 0);
	cout << endl;

	// fermer le socket
	::closesocket(sock);
	// Librer les ressources de la Winsock
	::WSACleanup();
	return EXIT_SUCCESS;
}