// SocketIPv6.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <winsock2.h>
#include <ws2tcpip.h>



#include <iostream>

using namespace std;

int main(int argc, char* argv[])
{
	WSADATA wsadata;
	SOCKADDR_STORAGE addr;
	SOCKET sock;


	if(::WSAStartup(MAKEWORD(2, 2), &wsadata))
	{
		cerr << "Impossible d'initialiser la Winsock" << endl;
		return EXIT_FAILURE;
	}
	cout << "Winsock initialisee" << endl;

	sock = socket(PF_INET6, SOCK_STREAM, 0);
	if(sock != INVALID_SOCKET)
		cout << "Socket cree" << endl;
	else
	{
		cerr << "Erreur a la creation du socket" << endl;
		::WSACleanup();
		return EXIT_FAILURE;
	}

	// Prparer l'adresse  laquelle se connecter
	memset(&addr, 0, sizeof(SOCKADDR_STORAGE));
	addr.ss_family = PF_INET6;
	struct sockaddr_in6* addr6 = (struct sockaddr_in6*)&addr;
	addr6->sin6_scope_id = 0;
	addr6->sin6_port = ::htons(80); // port 80 HTTP

	/*
	addr6->sin6_addr.u.Byte[0] = 0x20;
	addr6->sin6_addr.u.Byte[1] = 0x01;
	addr6->sin6_addr.u.Byte[2] = 0x41;
	addr6->sin6_addr.u.Byte[3] = 0xd0;
	addr6->sin6_addr.u.Byte[4] = 0x00;
	addr6->sin6_addr.u.Byte[5] = 0x01;
	addr6->sin6_addr.u.Byte[6] = 0xed;
	addr6->sin6_addr.u.Byte[7] = 0x34;
	addr6->sin6_addr.u.Byte[15] = 0x03;
	
	// ou bien
	*/

	const char* host = "2001:41d0:1:ed34::3";
	// inet_pton pas document dans MSDN de VS 2008 ?
	::inet_pton(AF_INET6, host, (void *)&addr6->sin6_addr);

	// se connecter
	if(::connect(sock, (sockaddr*)addr6, sizeof(sockaddr_in6)))
	{
		cerr << "Impossible de connecter le socket" << endl;
		::closesocket(sock);
		::WSACleanup();
		return EXIT_FAILURE;
	}
	else
		cout << "Socket connecte" << endl; 
	
	// crire dans le socket
	const char* commande = "GET / HTTP/1.0\r\n\r\n";
	if(::send(sock, commande, strlen(commande), 0) == SOCKET_ERROR)
	{
		cerr << "Erreur lors de l'criture dans le socket" << endl;
		::closesocket(sock);
		::WSACleanup();
		return EXIT_FAILURE;
	}
	else
		cout << "Commande envoyee" << endl;

	// recevoir les donnes du serveur
	const int bufsize = 1;
	char buffer = 0;
	
	int result = 0;
	cout << "Donnees lues:" << endl << endl;
	do
	{
		result = ::recv(sock, &buffer, bufsize, 0);
		if(result > 0)
			cout << buffer; 
	} while(result > 0);
	cout << endl;

	// fermer le socket
	::closesocket(sock);
	// Librer les ressources de la Winsock
	::WSACleanup();
	return EXIT_SUCCESS;
}