// Basic.cpp : Defines the entry point for the console application.
//

#include "COMUtils.h"
#include <sapi.h>
#include <iostream>

//#error  Adaptez le code ci-dessous  votre configuration
const WCHAR* chemin = L"c:\\temp\\helloworld.txt";

void Run()
{
	HRESULT hr;
	SmartCOMPtr<ISpVoice> ispvoice;

	hr = ::CoCreateInstance(
		CLSID_SpVoice, 
		NULL,
		CLSCTX_ALL,
		IID_ISpVoice,
		reinterpret_cast<void**>(&ispvoice));
	COMHelper::TestOk(hr);

	hr = ispvoice->Speak(L"Hello world", SPF_DEFAULT, NULL);
	COMHelper::TestOk(hr);
	std::cout << "Hello World synchrone" << std::endl;	
	
	std::cout << "Bemol sur un Hello World synchrone " << std::endl;	
	hr = ispvoice->Speak(L" <pitch middle = '-10'/> Hello world", SPF_IS_XML, NULL );
	COMHelper::TestOk(hr);

	hr = ispvoice->Speak(L"Hello world", SPF_ASYNC|SPF_PURGEBEFORESPEAK , NULL);
	COMHelper::TestOk(hr);
	std::cout << "Hello World asynchrone" << std::endl;
	// Sans temporisation la terminaison du programme 
	// coupe le sifflet  la voix :)
	::Sleep(2000);

	std::cout << "Debut d'un long speech" << std::endl;
	hr = ispvoice->Speak(L"Hello world number one", SPF_ASYNC|SPF_PURGEBEFORESPEAK, NULL);
	COMHelper::TestOk(hr);
	hr = ispvoice->Speak(L"Hello world number two", SPF_ASYNC, NULL);
	COMHelper::TestOk(hr);
	std::cout << "Attente de la fin du speech" << std::endl;
	hr = ispvoice->WaitUntilDone(30000);
	COMHelper::TestOk(hr);
	std::cout << "Le speech est fini" << std::endl;

	std::cout << "Debut d'un long speech depuis un fichier" << std::endl;
	hr = ispvoice->Speak(NULL, SPF_PURGEBEFORESPEAK, NULL);
	COMHelper::TestOk(hr);
	hr = ispvoice->Speak(chemin, SPF_ASYNC|SPF_IS_FILENAME|SPF_IS_XML, NULL);
	COMHelper::TestOk(hr);
	std::cout << "Attente de la fin du speech depuis un fichier" << std::endl;
	hr = ispvoice->WaitUntilDone(30000);
	COMHelper::TestOk(hr);
	std::cout << "Le speech depuis un fichier est fini" << std::endl;
}

int main(int argc, char** argv)
{
	try
	{
		COMInitializer ci;
		Run();
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
