

#include "COMUtils.h"
#include <sapi.h>
#include <sphelper.h>
#include <iostream>



void Run()
{
	HRESULT hr;
	SmartCOMPtr<ISpObjectTokenCategory>   pSpObjectTokenCategory;
	SmartCOMPtr<IEnumSpObjectTokens>      pSpEnumTokens;

	hr = ::SpGetCategoryFromId(SPCAT_VOICES, &pSpObjectTokenCategory);
	COMHelper::TestOk(hr);
	
	hr = pSpObjectTokenCategory->EnumTokens(NULL, NULL, &pSpEnumTokens);
	COMHelper::TestOk(hr);

	ULONG nb;
	hr = pSpEnumTokens->GetCount(&nb);
	COMHelper::TestOk(hr);
	std::cout << "Nb de voix sur la machine: " << nb << std::endl;
	for(ULONG i=0; i<nb; i++)
	{
		SmartCOMPtr<ISpObjectToken> pSpObjectToken;
		WCHAR *id;

		pSpEnumTokens->Item(i, &pSpObjectToken);
		pSpObjectToken->GetId(&id);
		std::wcout << id << std::endl;
		::CoTaskMemFree(id);
	}
}

int main(int argc, char** argv)
{
	try
	{
		COMInitializer ci;
		Run();
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
