// Basic.cpp : Defines the entry point for the console application.
//

#include "COMUtils.h"
#include <sapi.h>
#include <iostream>

/*
void Run()
{
	HRESULT hr;
	HANDLE event;
	SmartCOMPtr<ISpVoice> ispvoice;

	hr = ::CoCreateInstance(
		CLSID_SpVoice, 
		NULL,
		CLSCTX_ALL,
		IID_ISpVoice,
		reinterpret_cast<void**>(&ispvoice));
	COMHelper::TestOk(hr);

	hr = ispvoice->SetNotifyWin32Event();
	COMHelper::TestOk(hr);

	event = ispvoice->GetNotifyEventHandle();
	if(event == INVALID_HANDLE_VALUE)
		COMHelper::TestOk(E_FAIL);

	// Sans l'invocation  SetInterest, le mecanisme
	// de notification reste inactif.
	hr = ispvoice->SetInterest(SPFEI(SPEI_END_INPUT_STREAM), NULL);
	COMHelper::TestOk(hr);

	std::cout << "Hello World synchrone" << std::endl;
	hr = ispvoice->Speak(L"Hello world with synchronization", SPF_ASYNC|SPF_PURGEBEFORESPEAK, NULL);
	COMHelper::TestOk(hr);

	std::cout << "Attente de l'evenement de syncronisation" << std::endl;
	HANDLE tab_handle[1];
	tab_handle[0] = event;
	::WaitForMultipleObjects(1, tab_handle, FALSE, INFINITE);
	std::cout << "Evenement de syncronisation declenche" << std::endl;
	std::cout << "Le speech est fini :-)" << std::endl;	
}
*/


void Run()
{
	HRESULT hr;
	HANDLE event;
	SmartCOMPtr<ISpVoice> ispvoice;
	SmartCOMPtr<ISpNotifySource> pISpNotifySource;
	SmartCOMPtr<ISpEventSource> pISpEventSource;

	hr = ::CoCreateInstance(
		CLSID_SpVoice, 
		NULL,
		CLSCTX_ALL,
		IID_ISpVoice,
		reinterpret_cast<void**>(&ispvoice));
	COMHelper::TestOk(hr);
	
	hr = ispvoice->QueryInterface(IID_ISpNotifySource, reinterpret_cast<void**>(&pISpNotifySource));
	COMHelper::TestOk(hr);

	hr = pISpNotifySource->SetNotifyWin32Event();
	COMHelper::TestOk(hr);

	event = pISpNotifySource->GetNotifyEventHandle();
	if(event == INVALID_HANDLE_VALUE)
		COMHelper::TestOk(E_FAIL);

	// Sans l'invocation  SetInterest, le mecanisme
	// de notification reste inactif.
	hr = ispvoice->QueryInterface(IID_ISpEventSource, reinterpret_cast<void**>(&pISpEventSource));
	COMHelper::TestOk(hr);
	hr = pISpEventSource->SetInterest(SPFEI(SPEI_END_INPUT_STREAM), NULL);
	COMHelper::TestOk(hr);

	std::cout << "Hello World synchrone" << std::endl;
	hr = ispvoice->Speak(L"Hello world with synchronization", SPF_ASYNC|SPF_PURGEBEFORESPEAK, NULL);
	COMHelper::TestOk(hr);

	std::cout << "Attente de l'evenement de syncronisation" << std::endl;
	HANDLE tab_handle[1];
	tab_handle[0] = event;
	::WaitForMultipleObjects(1, tab_handle, FALSE, INFINITE);

	std::cout << "Evenement de syncronisation declenche" << std::endl;
	std::cout << "Le speech est fini :-)" << std::endl;	
}

int main(int argc, char** argv)
{
	try
	{
		COMInitializer ci;
		Run();
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
