// Basic.cpp : Defines the entry point for the console application.
//

#include "COMUtils.h"
#include <sapi.h>
#include <iostream>


void Run()
{
	HRESULT hr;
	SmartCOMPtr<ISpVoice> ispvoice;

	hr = ::CoCreateInstance(
		CLSID_SpVoice, 
		NULL,
		CLSCTX_ALL,
		IID_ISpVoice,
		reinterpret_cast<void**>(&ispvoice));
	COMHelper::TestOk(hr);

	std::cout << "Programmez anglais :-(" << std::endl;
	hr = ispvoice->Speak(L"programmez", SPF_DEFAULT, NULL);
	COMHelper::TestOk(hr);

	::Sleep(100);
	
	std::cout << "Programmez francais :-) " << std::endl;	
	hr = ispvoice->Speak(L" <PRON SYM = 'p r ao -  g r ae - 2 m ey !'/>", SPF_IS_XML, NULL );
	COMHelper::TestOk(hr);
}

int main(int argc, char** argv)
{
	try
	{
		COMInitializer ci;
		Run();
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
