#include "COMUtils.h"
#include <sapi.h>
#include <sphelper.h>
#include <iostream>

//#error: vrifiez que la SDK 5.1 est installe sur votre machine avant de lancer ce programme

SmartCOMPtr<ISpObjectToken>  GetVoice()
{
	HRESULT hr;
	SmartCOMPtr<ISpObjectTokenCategory>   pSpObjectTokenCategory;
	SmartCOMPtr<IEnumSpObjectTokens>      pSpEnumTokens;
	SmartCOMPtr<ISpObjectToken> pSpObjectToken;

	hr = ::SpGetCategoryFromId(SPCAT_VOICES, &pSpObjectTokenCategory);
	COMHelper::TestOk(hr);
	
	hr = pSpObjectTokenCategory->EnumTokens(NULL, NULL, &pSpEnumTokens);
	COMHelper::TestOk(hr);

	// SampleTTSVoice est install en 4me position par le SDK
	pSpEnumTokens->Item(3, &pSpObjectToken);  
	return pSpObjectToken;

}

void Run()
{
	HRESULT hr;
	SmartCOMPtr<ISpVoice> ispvoice;
	SmartCOMPtr<ISpObjectToken> pSpObjectToken;

	hr = ::CoCreateInstance(
		CLSID_SpVoice, 
		NULL,
		CLSCTX_ALL,
		IID_ISpVoice,
		reinterpret_cast<void**>(&ispvoice));
	COMHelper::TestOk(hr);

	pSpObjectToken = GetVoice();

	hr = ispvoice->SetVoice(*(&pSpObjectToken));

	hr = ispvoice->Speak(L"Hello world", SPF_DEFAULT, NULL);
	COMHelper::TestOk(hr);
}

int main(int argc, char** argv)
{
	std::cout << "ATTENTION: ce programme ne fonctionnera correctement" << std::endl;
	std::cout << "que si la Speech SDK 5.1 est installee sur votre machine" << std::endl;
	try
	{
		COMInitializer ci;
		Run();
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
