﻿using System;
using MPI;

namespace Broadcast
{
    class Program
    {
        static void Main(string[] args)
        {
            using (new MPI.Environment(ref args))
            {
                int valeur=0, result;

                Communicator world = Communicator.world;
                if (world.Rank == 0)
                    valeur = 10;
                // ici nous avons une barrière implicite
                // car l'exécution s'arrête tant qu'un message
                // n'a pas été envoyé à tout le monde
                world.Broadcast<int>(ref valeur, 0);
                // Puis l'exécution reprend
                result = valeur + world.Rank;
                Console.WriteLine("Résultat: {0}", result);
            }
        }
    }
}

