﻿using System;
using MPI;

class GatherBis
{
    static void Main(string[] args)
    {
        using (MPI.Environment env = new MPI.Environment(ref args))
        {
            int[][] results = null;

            Communicator world = Communicator.world;
            if (world.Size != 4)
            {
                Console.WriteLine("Vous devez lancer cette application MPI avec 4 processus");
                return;
            }
            // Dans le processus root, allocation du tableau
            // devant collecter les résultats
            if (world.Rank == 0)
            {
                results = new int[4][];
            }
            // Tous les processus y compris root
            // founissent un tableau de valeurs
            int[] valeurs = new int[3];
            valeurs[0] = world.Rank;
            valeurs[1] = world.Rank + 10;
            valeurs[2] = world.Rank + 20;

            world.Gather<int[]>(valeurs, 0, ref results);
            
            if (world.Rank == 0)
            {
                System.Console.WriteLine(results.ToString());
            
                for (int i = 0; i < results.Length; i++)
                {
                    int[] sub = results[i];
                    System.Console.WriteLine(sub.ToString());
                    for (int j = 0; j < sub.Length; j++)
                        System.Console.Write("{0}\n", sub[j]);
                }            
            }    
        }
    }
}
