﻿using System;
using MPI;

namespace HelloSendRecv
{
    class Program
    {
        static void Main(string[] args)
        {
            using (new MPI.Environment(ref args))
            {
                Communicator world = Communicator.world;
                if (Communicator.world.Rank == 0)
                {
                    for (int i = 1; i < Communicator.world.Size;i++ )
                    {
                        world.Send<String>("Hello", i, 0);
                    }
                    String data;
                    for (int i = 1; i < Communicator.world.Size; i++)
                    {
                        world.Receive<String>(Communicator.anySource, 0, out data);
                        // essayer
                        // world.Receive<String>(i, 0, out data);
                        // Pour constater l'ordre ou le désordre
                        // d'arrivée des messages
                        data += " recu par root";
                        Console.WriteLine(data);
                    }
                }
                else
                {
                    String data;

                    world.Receive<String>(Communicator.anySource, 0, out data);
                    data += " World de ";
                    data += world.Rank;
                    //Console.WriteLine(data);
                    world.Send<String>(data, 0, 0);
                }
            }
        }
    }
}
