﻿using System;
using MPI;

namespace Reduce
{
    class Program
    {
        static void Main(string[] args)
        {
            using (new MPI.Environment(ref args))
            {
                int valeur, result;

                Communicator world = Communicator.world;
                valeur = world.Rank;
                result = world.Reduce(valeur, Operation<int>.Add, 0);
                if(world.Rank == 0)
                    Console.WriteLine(result);
            }
        }
    }
}

/*


#include <mpi.h>
#include <stdio.h>
 
int main(int argc, char *argv[])
{
  int numprocs;
  int monid;
  int result;
 
  MPI_Init(&argc,&argv);
  MPI_Comm_size(MPI_COMM_WORLD,&numprocs);
  MPI_Comm_rank(MPI_COMM_WORLD,&monid);
 
  MPI_Reduce(&monid, &result, 1, MPI_INT, MPI_SUM, 0, MPI_COMM_WORLD);
  if(monid == 0)
    printf("Total des rang de processus: %d\n", result);
 
  MPI_Finalize();
  return 0;
}
*/