﻿using System;
using MPI;

class Scatter
{
    static void Main(string[] args)
    {
        using (MPI.Environment env = new MPI.Environment(ref args))
        {
            int[] valeurs = null;
            Communicator world = Communicator.world;
            if (world.Size != 4)
            {
                Console.WriteLine("Vous devez lancer cette application MPI avec 4 processus");
                return;
            }

            if (world.Rank == 0)
            {

                valeurs = new int[4];
                Random random = new Random();
                for (int i = 0; i < valeurs.Length; i++)
                {
                    valeurs[i] = random.Next(10);
                    Console.WriteLine(valeurs[i] + " ");
                }
            }
            int valeur = world.Scatter<int>(valeurs, 0);
            Console.WriteLine("Processus {0} à reçu: {1}", world.Rank, valeur);
        }
    }
}
