package programmez.fred.programmezplugin;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * Top component which displays something.
 */
final class ProgrammezWindowTopComponent extends TopComponent {
    
    private static final long serialVersionUID = 1L;
    
    private static ProgrammezWindowTopComponent instance;
    /** path to the icon used by the component and its open action */
    static final String ICON_PATH = "programmez/fred/programmezplugin/progicon.PNG";
    
    private static final String PREFERRED_ID = "ProgrammezWindowTopComponent";
    
    private ProgrammezWindowTopComponent() {
        initComponents();
        setName(NbBundle.getMessage(ProgrammezWindowTopComponent.class, "CTL_ProgrammezWindowTopComponent"));
        setToolTipText(NbBundle.getMessage(ProgrammezWindowTopComponent.class, "HINT_ProgrammezWindowTopComponent"));
        setIcon(Utilities.loadImage(ICON_PATH, true));
        
        
        Lookup.Template tpl = new Lookup.Template(EditorCookie.class);        
        Lookup.Result res = Utilities.actionsGlobalContext().lookup(tpl);
        
        res.addLookupListener(new LookupListener() {
            public void resultChanged(LookupEvent evt) {
                String msg = "";
                Collection c = ((Lookup.Result) evt.getSource()).allInstances();
                Iterator<EditorCookie> itc = c.iterator();
                if(itc.hasNext()) {
                    EditorCookie ec = itc.next();

                    JEditorPane[] panes = ec.getOpenedPanes();
                    if(panes.length >=1) {
                        try {
                            msg = panes[0].getText(0, 20);
                        } catch (BadLocationException ex) {
                            ex.printStackTrace();
                        }
                        
                        String tabName = NbBundle.getMessage(ProgrammezWindowTopComponent.class,"OpenIDE-Module-Name");
                        InputOutput io = IOProvider.getDefault().getIO(tabName,false);
                        io.select();
                        OutputWriter writer = io.getOut();
                        try {
                            writer.reset();
                        } catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        writer.write(msg);
                        writer.flush();
                        writer.close();
                    }
                }
                
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.Y_AXIS));

        jLabel1.setFont(new java.awt.Font("Times New Roman", 3, 24));
        jLabel1.setForeground(new java.awt.Color(51, 51, 255));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, "Programmez!");
        add(jLabel1);

        jLabel2.setFont(new java.awt.Font("Times New Roman", 3, 24));
        jLabel2.setForeground(new java.awt.Color(255, 51, 102));
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, " ");
        add(jLabel2);

        org.openide.awt.Mnemonics.setLocalizedText(jButton1, "Cliquez moi");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        add(jButton1);

    }// </editor-fold>//GEN-END:initComponents
    
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        jLabel2.setText("Abonnez vous: :-)");
    }//GEN-LAST:event_jButton1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    // End of variables declaration//GEN-END:variables
    
    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link findInstance}.
     */
    public static synchronized ProgrammezWindowTopComponent getDefault() {
        if (instance == null) {
            instance = new ProgrammezWindowTopComponent();
        }
        return instance;
    }
    
    /**
     * Obtain the ProgrammezWindowTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized ProgrammezWindowTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(ErrorManager.WARNING, "Cannot find ProgrammezWindow component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof ProgrammezWindowTopComponent) {
            return (ProgrammezWindowTopComponent)win;
        }
        ErrorManager.getDefault().log(ErrorManager.WARNING, "There seem to be multiple components with the '" + PREFERRED_ID + "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }
    
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }
    
    public void componentOpened() {
        // TODO add custom code on component opening
    }
    
    public void componentClosed() {
        // TODO add custom code on component closing
    }
    
    /** replaces this in object stream */
    public Object writeReplace() {
        return new ResolvableHelper();
    }
    
    protected String preferredID() {
        return PREFERRED_ID;
    }
    
    final static class ResolvableHelper implements Serializable {
        private static final long serialVersionUID = 1L;
        public Object readResolve() {
            return ProgrammezWindowTopComponent.getDefault();
        }
    }
    
}
