
package programmez;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import programmez.ProgrammezGPB.Auteur;
import programmez.ProgrammezGPB.InfosAuteurs;

public class GPBClient {

    public static void main(String[] args) throws IOException {
        Socket s = new Socket("localhost", 6969);
        s.setSoTimeout(5000);

        InputStream is = s.getInputStream();
        InfosAuteurs ia = InfosAuteurs.parseFrom(is);
        s.close();
        System.out.println("Message recu");


        for (Auteur auteur : ia.getAuteurList()) {
            System.out.println("Auteur ID: " + auteur.getId());
            System.out.println("Nom: " + auteur.getNom());
            if (auteur.hasEmail()) {
                System.out.println("E-mail: " + auteur.getEmail());
            }

            for (Auteur.Article article : auteur.getArticleList()) {
                System.out.println("Article: " + article.getTitre());
                switch (article.getType()) {
                    case DOSSIER:
                        System.out.println("Type: Dossier");
                        break;
                    case CODE:
                        System.out.println("Type: Code ");
                        break;
                }
            }
            System.out.println();
        }
    }
}
