package programmez;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GPBClientReflect {

    public static void main(String[] args) throws IOException {
        Socket s = new Socket("localhost", 6969);
        s.setSoTimeout(5000);

        InputStream is = s.getInputStream();

        Message.Builder mb = ProgrammezGPB.InfosAuteurs.newBuilder();
        mb.mergeFrom(is);
        s.close();
        System.out.println("Message recu\n-----------------");

        Map<Descriptors.FieldDescriptor, Object> all_fields = mb.getAllFields();
        //Message wrapper = mb.build();

        Set<Descriptors.FieldDescriptor> dset = all_fields.keySet();
        // Normalement ici il y a un seul enregistrement,
        // celui de la classe englobante.
        System.out.printf("Il y a %d enregistrement enveloppe dans le message\n", dset.size());
        // On obtient les informations sur le fichier .proto
        Iterator<Descriptors.FieldDescriptor> itdfd = dset.iterator();
        Descriptors.FieldDescriptor fd = itdfd.next();
        Descriptors.FileDescriptor dfd = fd.getFile();
        System.out.printf("Le nom du fichier .proto est %s\n", dfd.getName());
        System.out.printf("Le package est %s\n", dfd.getPackage());
        // On extrait les options du fichier .proto
        // pour obtenir le nom de la classe englobante.
        DescriptorProtos.FileOptions fo = dfd.getOptions();
        System.out.printf("La classe enveloppe %s\n", fo.getJavaOuterClassname());

        // Obtenir le type de l'enregistrement décrit.
        Descriptors.FieldDescriptor.JavaType tp = fd.getJavaType();
        System.out.printf("Le type de l'enregistrement est %s\n", tp.toString());

        // Maintenant on obtient une description des champs
        // des messages englobés
        Descriptors.Descriptor dd = fd.getMessageType();
        List<Descriptors.FieldDescriptor> ls = dd.getFields();
        System.out.println(ls.size());
        for (Descriptors.FieldDescriptor item : ls) {
            System.out.print(item.getName());
            System.out.println(" " + item.getJavaType());
        }
        
        // Maintenant on prend le premier descripteur de la liste
        // et on récupère son nom pour afficher
        // uniquement cette valeur depuis le message
        
        itdfd = ls.iterator(); // Voir plus haut déclaration itdfd
        String pour_recherche = itdfd.next().getName();
        System.out.println("Pour recherche: " + pour_recherche);
        
        // Puis on obtient et imprime les valeurs
        List msgs = (List) mb.getField(fd);
        System.out.printf("Nb messages contenus: %d\n", msgs.size());
        for (Object item : msgs) {
            System.out.println(item);
            Message m = (Message) item;
            Map<Descriptors.FieldDescriptor,Object> all_desc = m.getAllFields();
            Set<Descriptors.FieldDescriptor> all_desc_set = all_desc.keySet();
            for(Descriptors.FieldDescriptor item_bis : all_desc_set)
            {
                if (item_bis.getName().equals(pour_recherche)) {
                    Object nom = m.getField(item_bis);
                    System.out.println(nom);
                }
            }            
        }
    }
}
