
package programmez;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import programmez.ProgrammezGPB.Auteur;
import programmez.ProgrammezGPB.InfosAuteurs;


class SocketThread extends Thread {
    private Socket s;
    
    SocketThread(Socket s) {
        this.s = s;
    }

    @Override
    public void run() {
        try {
            InfosAuteurs.Builder infosauteurs = InfosAuteurs.newBuilder();
            // Définir un auteur et ses articles
            Auteur.Builder auteur = Auteur.newBuilder();
            // id:
            auteur.setId(1);
            // nom:
            auteur.setNom("Tonic");
            // e-mail:
            auteur.setEmail("ftonic@programmez.com");
            // Définir un article
            Auteur.Article.Builder article = Auteur.Article.newBuilder();
            article.setTitre("Developper Fun!");
            // On ne spécifie pas le type de l'article, donc
            // le type DOSSIER est attribué par défaut
            // Puis on attribue l'article à l'auteur
            auteur.addArticle(article);
            // On construit l'ensemble Auteur/Articles
            Auteur a = auteur.build();
            // Et on attribue les données au message
            infosauteurs.addAuteur(a);
            
            // On répète les opérations pour un autre auteur
            // ayant deux articles, dont un de type CODE
            auteur = Auteur.newBuilder();
            auteur.setId(2);
            auteur.setNom("Mazue");
            auteur.setEmail("fmazue@programmez.com");
            // Article 1
            article = Auteur.Article.newBuilder();
            article.setTitre("Le langage Dada");
            auteur.addArticle(article);
            // Article 2
            article = Auteur.Article.newBuilder();
            article.setTitre("DB API Python");
            article.setType(Auteur.ArticleType.CODE);
            auteur.addArticle(article);
            a = auteur.build();
            infosauteurs.addAuteur(a);
            // Enfin construire le message
            InfosAuteurs ia = infosauteurs.build();
            // envoyer les données
            OutputStream os = s.getOutputStream();
            ia.writeTo(os);
            // puis fermer le socket
            s.close();
            System.out.println("Message transmis");
        }
        catch(IOException ieo)
        {
            ieo.printStackTrace();
        }
    }
}

public class GPBServeur {

    private void go() throws IOException
    {
        ServerSocket ss = new ServerSocket(6969);
        while(true) {        
            Socket s = ss.accept();
            System.out.println("Connexion entrante");
            new SocketThread(s).start();
        }
    }

    
    public static void main(String[] args) throws IOException {
        GPBServeur gpbs = new GPBServeur();
        System.out.println("Serveur demarre -- Ctrl-c pour arreter");
        gpbs.go();
    }
}
