// ATTENTION !!! 
//
// En-ttes C++ AVANT enttes ruby.h


#include <new>
#include <iostream>
#include <cstdlib>


#include "ruby.h"

static const char* default_text = "Programmez!";
static VALUE ModuleProgrammez = Qnil;
static VALUE CharHolder = Qnil;

struct CharHolderData
{
	char* p;
	int length;
};

static void CharHolderMark(struct CharHolderData* chd)
{
}

static void CharHolderFree(struct CharHolderData* chd)
{
	delete[] chd->p;
	delete chd;
	std::cout << "Memoire de CharHolder liberee" << std::endl;
}


static VALUE CharHolderAllocate(VALUE klass)
{
	struct CharHolderData* chd;

	try
	{
		// Allocation d'une CharHolderData sur le tas,
		// c'est obligatoire...
		chd = new CharHolderData; 
		int size = strlen(default_text);
		chd->length = size;
		size++; // 0 final ;)
		// Les deux lignes ci-dessous
		// pour test manque de mmoire
		// std::bad_alloc ba;
		// throw ba;
		chd->p = new char[size];
		strcpy(chd->p, default_text);
		std::cout << "Allocation memoire pour" << std::endl;
		std::cout << "la classe CharHolder effectuee" << std::endl;
	}
	// Ne pas laisser passer une exception C++
	catch(std::bad_alloc)
	{
		std::cerr << "Impossible allouer memoire pour CharHolder" << std::endl;
		// et  la place, lever une exception Ruby
		rb_raise(rb_eRuntimeError, "Exception Ruby, manque de memoire");
	}
	return Data_Wrap_Struct(klass, CharHolderMark, CharHolderFree, chd);
}

static VALUE GetAt(VALUE object, VALUE index)
{
	struct CharHolderData* chd;
	int at;
	char buffer[2];

	// Avant toute chose,
	// Vrification du type reu
	Check_Type(index, T_FIXNUM);

	// rcuprer les donnes maintenues dans la classe
	Data_Get_Struct(object, struct CharHolderData, chd);
	
	at = NUM2INT(index);
	if(at < 0 || at > chd->length-1)
		rb_raise(rb_eRuntimeError, "Exception Ruby, indice incorrect");
	
	// Fabriquer une chaine Ruby  partir d'un caractre
	buffer[0] = chd->p[at];
	buffer[1] = 0;
	return rb_str_new2(buffer);
}

static void Set(VALUE object, VALUE text)
{
	char* newtext;
	int newlength;
	struct CharHolderData* chd;

	// Avant toute chose,
	// Vrification du type reu
	Check_Type(text, T_STRING);

	newtext = rb_string_value_cstr(&text);
	newlength = strlen(newtext);
	// rcuprer les donnes maintenues dans la classe
	Data_Get_Struct(object, struct CharHolderData, chd);

	try
	{
		// Les deux lignes ci-dessous
		// pour test manque de mmoire
		// std::bad_alloc ba;
		// throw ba;

		char* t = new char[newlength+1];
		strcpy(t, newtext);
		// Si tout est en ordre, valider
		// les rsultats
		delete[](chd->p);
		chd->p = t;
		chd->length = newlength;
		std::cout << "Reallocation memoire CharHolder effectuee" << std::endl;
	}
	// Ne pas laisser passer une exception C++
	catch(std::bad_alloc)
	{
		std::cerr << "Impossible de reallouer memoire pour CharHolder" << std::endl;
		// et  la place, lever une exception Ruby
		rb_raise(rb_eRuntimeError, "Exception Ruby, manque de memoire");
	}
}

extern "C" void Init_Programmez()
{
	// Cration du module 
	ModuleProgrammez = rb_define_module("Programmez");
	
	// Cration de la classe Ruby
	CharHolder = rb_define_class_under(
		ModuleProgrammez,
		"CharHolder", rb_cObject);
	// Dfinition de la mthode d'allocation
	rb_define_alloc_func(CharHolder, CharHolderAllocate);
	// Dfinition de la mthode GetAt
	rb_define_method(CharHolder, "GetAt", reinterpret_cast<VALUE (*)(...)>(GetAt), 1);
	// Dfinition de la mthode Set
	rb_define_method(CharHolder, "Set", reinterpret_cast<VALUE (*)(...)>(Set), 1);
	
}


